/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering;

import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.filesystem.FileIO;
import com.trivago.rta.filesystem.FileSystemManager;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.json.pojo.Tag;
import com.trivago.rta.properties.PropertyManager;
import com.trivago.rta.rendering.TemplateEngine;
import com.trivago.rta.rendering.pages.pojos.Feature;
import com.trivago.rta.rendering.pages.pojos.pagecollections.AllFeaturesPageCollection;
import com.trivago.rta.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.rta.rendering.pages.pojos.pagecollections.AllTagsPageCollection;
import com.trivago.rta.rendering.pages.pojos.pagecollections.ScenarioDetailsPageCollection;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ReportGenerator {
    private final TemplateEngine templateEngine;
    private final FileIO fileIO;
    private final PropertyManager propertyManager;
    private final FileSystemManager fileSystemManager;

    @Inject
    public ReportGenerator(TemplateEngine templateEngine, FileIO fileIO, PropertyManager propertyManager, FileSystemManager fileSystemManager) {
        this.templateEngine = templateEngine;
        this.fileIO = fileIO;
        this.propertyManager = propertyManager;
        this.fileSystemManager = fileSystemManager;
    }

    public void generateReport(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberPluginException {
        this.copyReportAssets();
        this.generateScenarioDetailPages(allScenariosPageCollection);
        this.generateFeaturePages(allScenariosPageCollection);
        this.generateTagPages(allScenariosPageCollection);
        this.generateScenarioSummaryPage(allScenariosPageCollection);
    }

    private void generateFeaturePages(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberPluginException {
        AllFeaturesPageCollection allFeaturesPageCollection = new AllFeaturesPageCollection(allScenariosPageCollection.getReports());
        this.fileIO.writeContentToFile(this.templateEngine.getRenderedFeatureSummaryPageContent(allFeaturesPageCollection), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/" + "feature-summary" + ".html");
        for (Feature feature : allFeaturesPageCollection.getFeatures()) {
            this.fileIO.writeContentToFile(this.templateEngine.getRenderedScenarioSummaryPageContentByFeatureFilter(allScenariosPageCollection, feature), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/feature-scenarios/feature_" + feature.getIndex() + ".html");
        }
    }

    private void generateTagPages(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberPluginException {
        AllTagsPageCollection allTagsPageCollection = new AllTagsPageCollection(allScenariosPageCollection.getReports());
        this.fileIO.writeContentToFile(this.templateEngine.getRenderedTagSummaryPageContent(allTagsPageCollection), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/" + "tag-summary" + ".html");
        for (Tag tag : allTagsPageCollection.getTags()) {
            this.fileIO.writeContentToFile(this.templateEngine.getRenderedScenarioSummaryPageContentByTagFilter(allScenariosPageCollection, tag), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/tag-scenarios/tag_" + tag.getUrlFriendlyName() + ".html");
        }
    }

    private void generateScenarioDetailPages(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberPluginException {
        for (Report report : allScenariosPageCollection.getReports()) {
            for (Element element : report.getElements()) {
                ScenarioDetailsPageCollection scenarioDetailsPageCollection = new ScenarioDetailsPageCollection(element);
                this.fileIO.writeContentToFile(this.templateEngine.getRenderedScenarioDetailPageContent(scenarioDetailsPageCollection), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/scenario-detail/scenario_" + element.getScenarioIndex() + ".html");
            }
        }
    }

    private void generateScenarioSummaryPage(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberPluginException {
        this.fileIO.writeContentToFile(this.templateEngine.getRenderedScenarioSummaryPageContent(allScenariosPageCollection), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "index" + ".html");
    }

    private void copyReportAssets() throws CluecumberPluginException {
        String reportDirectory = this.propertyManager.getGeneratedHtmlReportDirectory();
        this.fileSystemManager.createDirectory(reportDirectory);
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages");
        this.fileSystemManager.createDirectory(reportDirectory + "/" + "pages" + "/" + "scenario-detail");
        this.fileSystemManager.createDirectory(reportDirectory + "/" + "pages" + "/" + "feature-scenarios");
        this.fileSystemManager.createDirectory(reportDirectory + "/" + "pages" + "/" + "tag-scenarios");
        this.fileSystemManager.createDirectory(reportDirectory + "/js");
        this.fileSystemManager.createDirectory(reportDirectory + "/css");
        this.copyFileFromJarToReportDirectory("/css/bootstrap.min.css");
        this.copyFileFromJarToReportDirectory("/css/cluecumber.css");
        this.copyFileFromJarToReportDirectory("/css/datatables.min.css");
        this.copyFileFromJarToReportDirectory("/css/jquery.fancybox.min.css");
        this.copyFileFromJarToReportDirectory("/css/dataTables.bootstrap4.min.css");
        this.copyFileFromJarToReportDirectory("/js/jquery.min.js");
        this.copyFileFromJarToReportDirectory("/js/bootstrap.min.js");
        this.copyFileFromJarToReportDirectory("/js/popper.min.js");
        this.copyFileFromJarToReportDirectory("/js/Chart.bundle.min.js");
        this.copyFileFromJarToReportDirectory("/js/datatables.min.js");
        this.copyFileFromJarToReportDirectory("/js/jquery.fancybox.min.js");
    }

    private void copyFileFromJarToReportDirectory(String fileName) throws CluecumberPluginException {
        this.fileSystemManager.exportResource(this.getClass(), "/template" + fileName, this.propertyManager.getGeneratedHtmlReportDirectory() + fileName);
    }
}

