/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering;

import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.json.pojo.Tag;
import com.trivago.rta.rendering.RenderingUtils;
import com.trivago.rta.rendering.TemplateConfiguration;
import com.trivago.rta.rendering.pages.pojos.Feature;
import com.trivago.rta.rendering.pages.pojos.pagecollections.AllFeaturesPageCollection;
import com.trivago.rta.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.rta.rendering.pages.pojos.pagecollections.AllTagsPageCollection;
import com.trivago.rta.rendering.pages.pojos.pagecollections.ScenarioDetailsPageCollection;
import com.trivago.rta.rendering.pages.renderers.AllFeaturesPageRenderer;
import com.trivago.rta.rendering.pages.renderers.AllScenariosPageRenderer;
import com.trivago.rta.rendering.pages.renderers.AllTagsPageRenderer;
import com.trivago.rta.rendering.pages.renderers.ScenarioDetailsPageRenderer;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TemplateEngine {
    private final TemplateConfiguration templateConfiguration;
    private final AllFeaturesPageRenderer allFeaturesPageRenderer;
    private final AllTagsPageRenderer allTagsPageRenderer;
    private final ScenarioDetailsPageRenderer scenarioDetailsPageRenderer;
    private final AllScenariosPageRenderer allScenariosPageRenderer;

    @Inject
    public TemplateEngine(TemplateConfiguration templateConfiguration, AllFeaturesPageRenderer allFeaturesPageRenderer, AllTagsPageRenderer allTagsPageRenderer, ScenarioDetailsPageRenderer scenarioDetailsPageRenderer, AllScenariosPageRenderer allScenariosPageRenderer) {
        this.templateConfiguration = templateConfiguration;
        this.allFeaturesPageRenderer = allFeaturesPageRenderer;
        this.allScenariosPageRenderer = allScenariosPageRenderer;
        this.scenarioDetailsPageRenderer = scenarioDetailsPageRenderer;
        this.allTagsPageRenderer = allTagsPageRenderer;
        templateConfiguration.init(this.getClass(), "/template");
    }

    String getRenderedScenarioSummaryPageContent(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberPluginException {
        return RenderingUtils.prettifyHtml(this.allScenariosPageRenderer.getRenderedContent(allScenariosPageCollection, this.templateConfiguration.getTemplate("scenario-summary")));
    }

    String getRenderedScenarioSummaryPageContentByTagFilter(AllScenariosPageCollection allScenariosPageCollection, Tag tag) throws CluecumberPluginException {
        return RenderingUtils.prettifyHtml(this.allScenariosPageRenderer.getRenderedContentByTagFilter(allScenariosPageCollection, this.templateConfiguration.getTemplate("scenario-summary"), tag));
    }

    String getRenderedScenarioSummaryPageContentByFeatureFilter(AllScenariosPageCollection allScenariosPageCollection, Feature feature) throws CluecumberPluginException {
        return RenderingUtils.prettifyHtml(this.allScenariosPageRenderer.getRenderedContentByFeatureFilter(allScenariosPageCollection, this.templateConfiguration.getTemplate("scenario-summary"), feature));
    }

    String getRenderedScenarioDetailPageContent(ScenarioDetailsPageCollection scenarioDetailsPageCollection) throws CluecumberPluginException {
        return RenderingUtils.prettifyHtml(this.scenarioDetailsPageRenderer.getRenderedContent(scenarioDetailsPageCollection, this.templateConfiguration.getTemplate("scenario-detail")));
    }

    String getRenderedTagSummaryPageContent(AllTagsPageCollection allTagsPageCollection) throws CluecumberPluginException {
        return RenderingUtils.prettifyHtml(this.allTagsPageRenderer.getRenderedContent(allTagsPageCollection, this.templateConfiguration.getTemplate("tag-summary")));
    }

    String getRenderedFeatureSummaryPageContent(AllFeaturesPageCollection allFeaturesPageCollection) throws CluecumberPluginException {
        return RenderingUtils.prettifyHtml(this.allFeaturesPageRenderer.getRenderedContent(allFeaturesPageCollection, this.templateConfiguration.getTemplate("feature-summary")));
    }
}

