/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages.pojos.pagecollections;

import com.trivago.rta.constants.Status;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.rendering.pages.pojos.Feature;
import com.trivago.rta.rendering.pages.pojos.ResultCount;
import com.trivago.rta.rendering.pages.pojos.pagecollections.SummaryPageCollection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AllFeaturesPageCollection
extends SummaryPageCollection {
    private Map<Feature, ResultCount> resultCounts;

    public AllFeaturesPageCollection(List<Report> reports) {
        super("Feature Summary");
        this.calculateFeatureResultCounts(reports);
    }

    public Map<Feature, ResultCount> getFeatureResultCounts() {
        return this.resultCounts;
    }

    public Set<Feature> getFeatures() {
        return this.resultCounts.keySet();
    }

    public int getTotalNumberOfFeatures() {
        return this.resultCounts.size();
    }

    public int getTotalNumberOfPassedFeatures() {
        return this.getNumberOfResultsWithStatus(this.resultCounts.values(), Status.PASSED);
    }

    public int getTotalNumberOfFailedFeatures() {
        return this.getNumberOfResultsWithStatus(this.resultCounts.values(), Status.FAILED);
    }

    public int getTotalNumberOfSkippedFeatures() {
        return this.getNumberOfResultsWithStatus(this.resultCounts.values(), Status.SKIPPED);
    }

    private void calculateFeatureResultCounts(List<Report> reports) {
        if (reports == null) {
            return;
        }
        this.resultCounts = new HashMap<Feature, ResultCount>();
        for (Report report : reports) {
            Feature feature = new Feature(report.getName(), report.getFeatureIndex());
            ResultCount featureResultCount = this.resultCounts.getOrDefault(feature, new ResultCount());
            for (Element element : report.getElements()) {
                this.updateResultCount(featureResultCount, element.getStatus());
            }
            this.resultCounts.put(feature, featureResultCount);
        }
    }
}

