/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages.renderers;

import com.rits.cloning.Cloner;
import com.trivago.rta.constants.ChartColor;
import com.trivago.rta.constants.Status;
import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.json.pojo.Tag;
import com.trivago.rta.properties.PropertyManager;
import com.trivago.rta.rendering.charts.ChartJsonConverter;
import com.trivago.rta.rendering.charts.pojos.Chart;
import com.trivago.rta.rendering.charts.pojos.Data;
import com.trivago.rta.rendering.charts.pojos.Dataset;
import com.trivago.rta.rendering.pages.pojos.CustomParameter;
import com.trivago.rta.rendering.pages.pojos.Feature;
import com.trivago.rta.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.rta.rendering.pages.renderers.PageRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AllScenariosPageRenderer
extends PageRenderer {
    private final PropertyManager propertyManager;
    private final Cloner cloner;

    @Inject
    public AllScenariosPageRenderer(ChartJsonConverter chartJsonConverter, PropertyManager propertyManager) {
        super(chartJsonConverter);
        this.propertyManager = propertyManager;
        this.cloner = new Cloner();
    }

    public String getRenderedContent(AllScenariosPageCollection allScenariosPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(allScenariosPageCollection);
        this.addCustomParametersToReportDetails(allScenariosPageCollection);
        return this.processedContent(template, allScenariosPageCollection);
    }

    public String getRenderedContentByTagFilter(AllScenariosPageCollection allScenariosPageCollection, Template template, Tag tag) throws CluecumberPluginException {
        AllScenariosPageCollection allScenariosPageCollectionClone = (AllScenariosPageCollection)this.cloner.deepClone((Object)allScenariosPageCollection);
        allScenariosPageCollectionClone.setTagFilter(tag);
        for (Report report : allScenariosPageCollectionClone.getReports()) {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element element : report.getElements()) {
                if (!element.getTags().contains(tag)) continue;
                elements.add(element);
            }
            report.setElements(elements);
        }
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone);
    }

    public String getRenderedContentByFeatureFilter(AllScenariosPageCollection allScenariosPageCollection, Template template, Feature feature) throws CluecumberPluginException {
        AllScenariosPageCollection allScenariosPageCollectionClone = (AllScenariosPageCollection)this.cloner.deepClone((Object)allScenariosPageCollection);
        allScenariosPageCollectionClone.setFeatureFilter(feature);
        ArrayList<Report> reports = new ArrayList<Report>();
        for (Report report : allScenariosPageCollectionClone.getReports()) {
            if (report.getFeatureIndex() != feature.getIndex()) continue;
            reports.add(report);
        }
        Report[] reportArray = reports.toArray(new Report[0]);
        allScenariosPageCollectionClone.clearReports();
        allScenariosPageCollectionClone.addReports(reportArray);
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone);
    }

    private void addChartJsonToReportDetails(AllScenariosPageCollection allScenariosPageCollection) {
        Chart chart = new Chart();
        Data data = new Data();
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(Status.PASSED.getStatusString());
        labels.add(Status.FAILED.getStatusString());
        labels.add(Status.SKIPPED.getStatusString());
        data.setLabels(labels);
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        Dataset dataset = new Dataset();
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(allScenariosPageCollection.getTotalNumberOfPassedScenarios());
        values.add(allScenariosPageCollection.getTotalNumberOfFailedScenarios());
        values.add(allScenariosPageCollection.getTotalNumberOfSkippedScenarios());
        dataset.setData(values);
        datasets.add(dataset);
        ArrayList<String> backgroundColors = new ArrayList<String>();
        backgroundColors.add(ChartColor.getChartColorStringByStatus(Status.PASSED));
        backgroundColors.add(ChartColor.getChartColorStringByStatus(Status.FAILED));
        backgroundColors.add(ChartColor.getChartColorStringByStatus(Status.SKIPPED));
        dataset.setBackgroundColor(backgroundColors);
        data.setDatasets(datasets);
        chart.setData(data);
        chart.setType(Chart.ChartType.pie);
        allScenariosPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }

    private void addCustomParametersToReportDetails(AllScenariosPageCollection allScenariosPageCollection) {
        Map<String, String> customParameterMap = this.propertyManager.getCustomParameters();
        if (customParameterMap == null || customParameterMap.isEmpty()) {
            return;
        }
        ArrayList<CustomParameter> customParameters = new ArrayList<CustomParameter>();
        for (Map.Entry<String, String> stringStringEntry : customParameterMap.entrySet()) {
            String key = stringStringEntry.getKey().replace("_", " ");
            CustomParameter customParameter = new CustomParameter(key, stringStringEntry.getValue());
            customParameters.add(customParameter);
        }
        allScenariosPageCollection.setCustomParameters(customParameters);
    }

    public static enum Filter {
        TAG,
        FEATURE;

    }
}

