/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages.renderers;

import com.trivago.rta.constants.ChartColor;
import com.trivago.rta.constants.Status;
import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.ResultMatch;
import com.trivago.rta.rendering.charts.ChartJsonConverter;
import com.trivago.rta.rendering.charts.pojos.Axis;
import com.trivago.rta.rendering.charts.pojos.Chart;
import com.trivago.rta.rendering.charts.pojos.Data;
import com.trivago.rta.rendering.charts.pojos.Dataset;
import com.trivago.rta.rendering.charts.pojos.Options;
import com.trivago.rta.rendering.charts.pojos.ScaleLabel;
import com.trivago.rta.rendering.charts.pojos.Scales;
import com.trivago.rta.rendering.charts.pojos.Ticks;
import com.trivago.rta.rendering.pages.pojos.pagecollections.ScenarioDetailsPageCollection;
import com.trivago.rta.rendering.pages.renderers.PageRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScenarioDetailsPageRenderer
extends PageRenderer {
    @Inject
    public ScenarioDetailsPageRenderer(ChartJsonConverter chartJsonConverter) {
        super(chartJsonConverter);
    }

    public String getRenderedContent(ScenarioDetailsPageCollection scenarioDetailsPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(scenarioDetailsPageCollection);
        return this.processedContent(template, scenarioDetailsPageCollection);
    }

    private void addChartJsonToReportDetails(ScenarioDetailsPageCollection scenarioDetailsPageCollection) {
        Chart chart = new Chart();
        Element element = scenarioDetailsPageCollection.getElement();
        ArrayList<String> labels = new ArrayList<String>();
        IntStream.rangeClosed(1, element.getBefore().size()).mapToObj(i -> "Before " + i).forEachOrdered(labels::add);
        IntStream.rangeClosed(1, element.getSteps().size()).mapToObj(i -> "Step " + i).forEachOrdered(labels::add);
        if (element.getAfter().size() > 0) {
            IntStream.rangeClosed(element.getBefore().size(), element.getAfter().size()).mapToObj(i -> "After " + i).forEachOrdered(labels::add);
        }
        Data data = new Data();
        data.setLabels(labels);
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        for (Status status : Status.BASIC_STATES) {
            Dataset dataset = new Dataset();
            ArrayList<Integer> dataList = new ArrayList<Integer>();
            for (ResultMatch resultMatch : element.getAllResultMatches()) {
                if (resultMatch.getConsolidatedStatus() == status) {
                    dataList.add((int)resultMatch.getResult().getDurationInMilliseconds());
                    continue;
                }
                dataList.add(0);
            }
            dataset.setData(dataList);
            dataset.setLabel(status.getStatusString());
            dataset.setStack("complete");
            dataset.setBackgroundColor(new ArrayList<String>(Collections.nCopies(dataList.size(), ChartColor.getChartColorStringByStatus(status))));
            datasets.add(dataset);
        }
        data.setDatasets(datasets);
        chart.setData(data);
        Options options = new Options();
        Scales scales = new Scales();
        ArrayList<Axis> xAxes = new ArrayList<Axis>();
        Axis xAxis = new Axis();
        xAxis.setStacked(true);
        Ticks xTicks = new Ticks();
        xAxis.setTicks(xTicks);
        ScaleLabel xScaleLabel = new ScaleLabel();
        xScaleLabel.setDisplay(true);
        xScaleLabel.setLabelString("Step(s)");
        xAxis.setScaleLabel(xScaleLabel);
        xAxes.add(xAxis);
        scales.setxAxes(xAxes);
        ArrayList<Axis> yAxes = new ArrayList<Axis>();
        Axis yAxis = new Axis();
        yAxis.setStacked(true);
        Ticks yTicks = new Ticks();
        yAxis.setTicks(yTicks);
        ScaleLabel yScaleLabel = new ScaleLabel();
        yScaleLabel.setDisplay(true);
        yScaleLabel.setLabelString("Step Runtime");
        yAxis.setScaleLabel(yScaleLabel);
        yAxes.add(yAxis);
        scales.setyAxes(yAxes);
        options.setScales(scales);
        chart.setOptions(options);
        chart.setType(Chart.ChartType.bar);
        scenarioDetailsPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }
}

