/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.json.postprocessors;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Report;
import io.gsonfire.PostProcessor;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ReportPostProcessor
implements PostProcessor<Report> {
    private final List<String> featureUris = new ArrayList<String>();

    @Inject
    public ReportPostProcessor() {
    }

    public void postDeserialize(Report report, JsonElement jsonElement, Gson gson) {
        this.mergeBackgroundScenarios(report);
        this.addFeatureIndex(report);
    }

    private void addFeatureIndex(Report report) {
        if (report == null) {
            return;
        }
        String featureName = report.getName();
        if (!this.featureUris.contains(featureName)) {
            this.featureUris.add(featureName);
        }
        report.setFeatureIndex(this.featureUris.indexOf(featureName));
    }

    private void mergeBackgroundScenarios(Report report) {
        ArrayList<Element> cleanedUpElements = new ArrayList<Element>();
        Element currentBackgroundElement = null;
        for (Element element : report.getElements()) {
            if (element.getType().equalsIgnoreCase("background")) {
                currentBackgroundElement = element;
                continue;
            }
            if (currentBackgroundElement != null) {
                element.getSteps().addAll(0, currentBackgroundElement.getSteps());
            }
            cleanedUpElements.add(element);
        }
        report.setElements(cleanedUpElements);
    }

    public void postSerialize(JsonElement jsonElement, Report report, Gson gson) {
    }
}

