/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.filesystem.FileIO;
import com.trivago.cluecumber.filesystem.FileSystemManager;
import com.trivago.cluecumber.json.JsonPojoConverter;
import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.logging.CluecumberLogger;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.ReportGenerator;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="reporting")
public final class CluecumberReportPlugin
extends AbstractMojo {
    private final CluecumberLogger logger;
    private final PropertyManager propertyManager;
    private final FileSystemManager fileSystemManager;
    private final FileIO fileIO;
    private final JsonPojoConverter jsonPojoConverter;
    private final ReportGenerator reportGenerator;
    @Parameter(property="reporting.sourceJsonReportDirectory", required=true)
    private String sourceJsonReportDirectory = "";
    @Parameter(property="reporting.generatedHtmlReportDirectory", required=true)
    private String generatedHtmlReportDirectory = "";
    @Parameter(property="reporting.customParameters")
    private Map<String, String> customParameters = new HashMap<String, String>();
    @Parameter(property="reporting.customCss")
    private String customCss = "";
    @Parameter(defaultValue="false", property="skip")
    private boolean skip;

    @Inject
    public CluecumberReportPlugin(CluecumberLogger logger, PropertyManager propertyManager, FileSystemManager fileSystemManager, FileIO fileIO, JsonPojoConverter jsonPojoConverter, ReportGenerator reportGenerator) {
        this.propertyManager = propertyManager;
        this.fileSystemManager = fileSystemManager;
        this.fileIO = fileIO;
        this.jsonPojoConverter = jsonPojoConverter;
        this.logger = logger;
        this.reportGenerator = reportGenerator;
    }

    public void execute() throws CluecumberPluginException {
        this.logger.setMojoLogger(this.getLog());
        if (this.skip) {
            this.getLog().info((CharSequence)"Cluecumber report generation was skipped by a configuration flag.");
            return;
        }
        this.propertyManager.setSourceJsonReportDirectory(this.sourceJsonReportDirectory);
        this.propertyManager.setGeneratedHtmlReportDirectory(this.generatedHtmlReportDirectory);
        this.propertyManager.setCustomParameters(this.customParameters);
        this.propertyManager.setCustomCss(this.customCss);
        this.propertyManager.validateSettings();
        this.logger.info("-----------------------------------------------");
        this.logger.info(String.format(" Cluecumber Report Maven Plugin, version %s", ((Object)((Object)this)).getClass().getPackage().getImplementationVersion()));
        this.logger.info("-----------------------------------------------");
        this.propertyManager.logProperties();
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + "/attachments");
        AllScenariosPageCollection allScenariosPageCollection = new AllScenariosPageCollection();
        List<Path> jsonFilePaths = this.fileSystemManager.getJsonFilePaths(this.propertyManager.getSourceJsonReportDirectory());
        for (Path jsonFilePath : jsonFilePaths) {
            String jsonString = this.fileIO.readContentFromFile(jsonFilePath.toString());
            try {
                Report[] reports = this.jsonPojoConverter.convertJsonToReportPojos(jsonString);
                allScenariosPageCollection.addReports(reports);
            }
            catch (CluecumberPluginException e) {
                this.logger.error("Could not parse JSON in file '" + jsonFilePath.toString() + "': " + e.getMessage());
            }
        }
        this.reportGenerator.generateReport(allScenariosPageCollection);
        this.logger.info("* Cluecumber Report: " + this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "index" + ".html");
    }
}

