/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.properties;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.exceptions.properties.WrongOrMissingPropertyException;
import com.trivago.cluecumber.logging.CluecumberLogger;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PropertyManager {
    private final CluecumberLogger logger;
    private String sourceJsonReportDirectory;
    private String generatedHtmlReportDirectory;
    private Map<String, String> customParameters;
    private String customCss;

    @Inject
    public PropertyManager(CluecumberLogger logger) {
        this.logger = logger;
    }

    public String getSourceJsonReportDirectory() {
        return this.sourceJsonReportDirectory;
    }

    public void setSourceJsonReportDirectory(String reportDirectory) {
        this.sourceJsonReportDirectory = reportDirectory;
    }

    public String getGeneratedHtmlReportDirectory() {
        return this.generatedHtmlReportDirectory;
    }

    public void setGeneratedHtmlReportDirectory(String generatedHtmlReportDirectory) {
        this.generatedHtmlReportDirectory = generatedHtmlReportDirectory;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public void setCustomParameters(Map<String, String> customParameters) {
        this.customParameters = customParameters;
    }

    public String getCustomCss() {
        return this.customCss;
    }

    public void setCustomCss(String customCss) {
        this.customCss = customCss;
    }

    public void validateSettings() throws CluecumberPluginException {
        String missingProperty = null;
        if (this.sourceJsonReportDirectory == null || this.sourceJsonReportDirectory.equals("")) {
            missingProperty = "sourceJsonReportDirectory";
        } else if (this.generatedHtmlReportDirectory == null || this.generatedHtmlReportDirectory.equals("")) {
            missingProperty = "generatedHtmlReportDirectory";
        }
        if (missingProperty != null) {
            throw new WrongOrMissingPropertyException(missingProperty);
        }
    }

    public void logProperties() {
        this.logger.info("- source JSON report directory    : " + this.sourceJsonReportDirectory);
        this.logger.info("- generated HTML report directory : " + this.generatedHtmlReportDirectory);
        if (this.customParameters != null && !this.customParameters.isEmpty()) {
            for (Map.Entry<String, String> entry : this.customParameters.entrySet()) {
                this.logger.info("- custom parameter                : " + entry.getKey() + " -> " + entry.getValue());
            }
        }
        if (this.customCss != null && !this.customCss.isEmpty()) {
            this.logger.info("- custom CSS                      : " + this.customCss);
        }
        this.logger.info("------------------------------------------------------------------------");
    }
}

