/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.json.pojo;

import com.google.gson.annotations.SerializedName;
import com.trivago.cluecumber.constants.MimeType;
import java.nio.charset.StandardCharsets;
import org.codehaus.plexus.util.Base64;

public class Embedding {
    private String data;
    private String decodedData;
    @SerializedName(value="mime_type")
    private MimeType mimeType = MimeType.UNKNOWN;
    private transient String filename;

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getDecodedData() {
        return this.decodedData;
    }

    public void encodeData(String data) {
        if (this.mimeType.getContentType().equalsIgnoreCase("text/xml") || this.mimeType.getContentType().equalsIgnoreCase("application/xml")) {
            String xmlString = new String(Base64.decodeBase64((byte[])data.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            this.decodedData = xmlString.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        } else {
            this.decodedData = new String(Base64.decodeBase64((byte[])data.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isImage() {
        return this.mimeType.getContentType().equalsIgnoreCase("image/png") || this.mimeType.getContentType().equalsIgnoreCase("image/gif") || this.mimeType.getContentType().equalsIgnoreCase("image/bmp") || this.mimeType.getContentType().equalsIgnoreCase("image/jpg") || this.mimeType.getContentType().equalsIgnoreCase("image/jpeg") || this.mimeType.getContentType().equalsIgnoreCase("image/svg") || this.mimeType.getContentType().equalsIgnoreCase("image/svg+xml");
    }

    public boolean isPlainText() {
        return this.mimeType.getContentType().equalsIgnoreCase("text/plain");
    }

    public String getFileEnding() {
        switch (this.mimeType) {
            case PNG: 
            case GIF: 
            case BMP: 
            case JPG: 
            case JPEG: 
            case HTML: 
            case XML: 
            case JSON: 
            case APPLICATION_XML: {
                return this.mimeType.getContentType().substring(this.mimeType.getContentType().indexOf(47) + 1);
            }
            case SVG: 
            case SVG_XML: {
                return "svg";
            }
            case TXT: {
                return "txt";
            }
            case PDF: {
                return "pdf";
            }
        }
        return "unknown";
    }
}

