/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.pojos.pagecollections;

import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.json.pojo.Tag;
import com.trivago.cluecumber.rendering.RenderingUtils;
import com.trivago.cluecumber.rendering.pages.pojos.CustomParameter;
import com.trivago.cluecumber.rendering.pages.pojos.Feature;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.PageCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AllScenariosPageCollection
extends PageCollection {
    private List<Report> reports = new ArrayList<Report>();
    private List<CustomParameter> customParameters;
    private Tag tagFilter;
    private Feature featureFilter;

    public AllScenariosPageCollection() {
        super("Scenario Summary");
    }

    public List<Report> getReports() {
        return this.reports;
    }

    public void clearReports() {
        this.reports = new ArrayList<Report>();
    }

    public void addReports(Report[] reportList) {
        if (reportList == null) {
            return;
        }
        this.reports.addAll(Arrays.asList(reportList));
    }

    public int getTotalNumberOfScenarios() {
        return this.reports.stream().map(Report::getElements).mapToInt(elements -> (int)elements.stream().filter(Element::isScenario).count()).sum();
    }

    public boolean hasFailedScenarios() {
        return this.getTotalNumberOfFailedScenarios() > 0;
    }

    public boolean hasPassedScenarios() {
        return this.getTotalNumberOfPassedScenarios() > 0;
    }

    public boolean hasSkippedScenarios() {
        return this.getTotalNumberOfSkippedScenarios() > 0;
    }

    public int getTotalNumberOfPassedScenarios() {
        return this.getNumberOfScenariosWithStatus(Status.PASSED);
    }

    public int getTotalNumberOfFailedScenarios() {
        return this.getNumberOfScenariosWithStatus(Status.FAILED);
    }

    public int getTotalNumberOfSkippedScenarios() {
        return this.getNumberOfScenariosWithStatus(Status.SKIPPED);
    }

    private int getNumberOfScenariosWithStatus(Status status) {
        return this.reports.stream().mapToInt(report -> (int)report.getElements().stream().filter(element -> element.getStatus().equals((Object)status)).count()).sum();
    }

    public long getTotalDuration() {
        long totalDurationMicroseconds = 0L;
        for (Report report : this.reports) {
            totalDurationMicroseconds += report.getTotalDuration();
        }
        return totalDurationMicroseconds;
    }

    public String getTotalDurationString() {
        return RenderingUtils.convertMicrosecondsToTimeString(this.getTotalDuration());
    }

    public List<CustomParameter> getCustomParameters() {
        return this.customParameters;
    }

    public void setCustomParameters(List<CustomParameter> customParameters) {
        this.customParameters = customParameters;
    }

    public boolean hasCustomParameters() {
        return this.customParameters != null && !this.customParameters.isEmpty();
    }

    public Tag getTagFilter() {
        return this.tagFilter;
    }

    public void setTagFilter(Tag tagFilter) {
        this.tagFilter = tagFilter;
    }

    public Feature getFeatureFilter() {
        return this.featureFilter;
    }

    public void setFeatureFilter(Feature featureFilter) {
        this.featureFilter = featureFilter;
    }
}

