/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.pojos.pagecollections;

import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.json.pojo.Tag;
import com.trivago.cluecumber.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.SummaryPageCollection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AllTagsPageCollection
extends SummaryPageCollection {
    private Map<Tag, ResultCount> tagResultCounts;

    public AllTagsPageCollection(List<Report> reports) {
        super("Tag Summary");
        this.calculateTagResultCounts(reports);
    }

    public Map<Tag, ResultCount> getTagResultCounts() {
        return this.tagResultCounts;
    }

    public Set<Tag> getTags() {
        return this.tagResultCounts.keySet();
    }

    public int getTotalNumberOfTags() {
        return this.tagResultCounts.size();
    }

    public int getTotalNumberOfPassedTags() {
        return this.getNumberOfResultsWithStatus(this.tagResultCounts.values(), Status.PASSED);
    }

    public int getTotalNumberOfFailedTags() {
        return this.getNumberOfResultsWithStatus(this.tagResultCounts.values(), Status.FAILED);
    }

    public int getTotalNumberOfSkippedTags() {
        return this.getNumberOfResultsWithStatus(this.tagResultCounts.values(), Status.SKIPPED);
    }

    private void calculateTagResultCounts(List<Report> reports) {
        if (reports == null) {
            return;
        }
        this.tagResultCounts = new HashMap<Tag, ResultCount>();
        for (Report report : reports) {
            for (Element element : report.getElements()) {
                for (Tag tag : element.getTags()) {
                    ResultCount tagResultCount = this.tagResultCounts.getOrDefault(tag, new ResultCount());
                    this.updateResultCount(tagResultCount, element.getStatus());
                    this.tagResultCounts.put(tag, tagResultCount);
                }
            }
        }
    }
}

