/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderers;

import com.trivago.cluecumber.constants.ChartColor;
import com.trivago.cluecumber.constants.ChartType;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.rendering.charts.ChartJsonConverter;
import com.trivago.cluecumber.rendering.charts.pojos.Axis;
import com.trivago.cluecumber.rendering.charts.pojos.Chart;
import com.trivago.cluecumber.rendering.charts.pojos.Data;
import com.trivago.cluecumber.rendering.charts.pojos.Dataset;
import com.trivago.cluecumber.rendering.charts.pojos.Options;
import com.trivago.cluecumber.rendering.charts.pojos.ScaleLabel;
import com.trivago.cluecumber.rendering.charts.pojos.Scales;
import com.trivago.cluecumber.rendering.charts.pojos.Ticks;
import com.trivago.cluecumber.rendering.pages.pojos.Feature;
import com.trivago.cluecumber.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllFeaturesPageCollection;
import com.trivago.cluecumber.rendering.pages.renderers.PageRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AllFeaturesPageRenderer
extends PageRenderer {
    @Inject
    public AllFeaturesPageRenderer(ChartJsonConverter chartJsonConverter) {
        super(chartJsonConverter);
    }

    public String getRenderedContent(AllFeaturesPageCollection allFeaturesPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(allFeaturesPageCollection);
        return this.processedContent(template, allFeaturesPageCollection);
    }

    private void addChartJsonToReportDetails(AllFeaturesPageCollection allFeaturesPageCollection) {
        Chart chart = new Chart();
        Data data = new Data();
        chart.setData(data);
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        ArrayList<Integer> passed = new ArrayList<Integer>();
        ArrayList<Integer> failed = new ArrayList<Integer>();
        ArrayList<Integer> skipped = new ArrayList<Integer>();
        int maxY = 0;
        for (Map.Entry<Feature, ResultCount> entry : allFeaturesPageCollection.getFeatureResultCounts().entrySet()) {
            passed.add(entry.getValue().getPassed());
            failed.add(entry.getValue().getFailed());
            skipped.add(entry.getValue().getSkipped());
            maxY = entry.getValue().getTotal();
        }
        Dataset passedDataset = new Dataset();
        passedDataset.setLabel(Status.PASSED.getStatusString());
        passedDataset.setData(passed);
        ArrayList<String> passedBG = new ArrayList<String>(Collections.nCopies(passed.size(), ChartColor.getChartColorStringByStatus(Status.PASSED)));
        passedDataset.setBackgroundColor(passedBG);
        datasets.add(passedDataset);
        Dataset failedDataset = new Dataset();
        failedDataset.setLabel(Status.FAILED.getStatusString());
        failedDataset.setData(failed);
        ArrayList<String> failedBG = new ArrayList<String>(Collections.nCopies(passed.size(), ChartColor.getChartColorStringByStatus(Status.FAILED)));
        failedDataset.setBackgroundColor(failedBG);
        datasets.add(failedDataset);
        Dataset skippedDataset = new Dataset();
        skippedDataset.setLabel(Status.SKIPPED.getStatusString());
        skippedDataset.setData(skipped);
        ArrayList<String> skippedBG = new ArrayList<String>(Collections.nCopies(passed.size(), ChartColor.getChartColorStringByStatus(Status.SKIPPED)));
        skippedDataset.setBackgroundColor(skippedBG);
        datasets.add(skippedDataset);
        data.setDatasets(datasets);
        ArrayList<String> keys = new ArrayList<String>();
        for (Feature feature : allFeaturesPageCollection.getFeatureResultCounts().keySet()) {
            keys.add(feature.getName());
        }
        data.setLabels(keys);
        Options options = new Options();
        Scales scales = new Scales();
        ArrayList<Axis> xAxes = new ArrayList<Axis>();
        Axis xAxis = new Axis();
        xAxis.setStacked(true);
        Ticks xTicks = new Ticks();
        xTicks.setDisplay(false);
        xAxis.setTicks(xTicks);
        ScaleLabel xScaleLabel = new ScaleLabel();
        xScaleLabel.setDisplay(true);
        xScaleLabel.setLabelString(allFeaturesPageCollection.getTotalNumberOfFeatures() + " Feature(s)");
        xAxis.setScaleLabel(xScaleLabel);
        xAxes.add(xAxis);
        scales.setxAxes(xAxes);
        ArrayList<Axis> yAxes = new ArrayList<Axis>();
        Axis yAxis = new Axis();
        yAxis.setStacked(true);
        Ticks yTicks = new Ticks();
        yAxis.setTicks(yTicks);
        ScaleLabel yScaleLabel = new ScaleLabel();
        yScaleLabel.setDisplay(true);
        yScaleLabel.setLabelString("Number of Scenarios");
        yAxis.setScaleLabel(yScaleLabel);
        yAxis.setStepSize(maxY);
        yAxes.add(yAxis);
        scales.setyAxes(yAxes);
        options.setScales(scales);
        chart.setOptions(options);
        chart.setType(ChartType.bar);
        allFeaturesPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }
}

