/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.json.pojo;

import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.json.pojo.ResultMatch;
import com.trivago.cluecumber.json.pojo.Step;
import com.trivago.cluecumber.json.pojo.Tag;
import com.trivago.cluecumber.rendering.RenderingUtils;
import java.util.ArrayList;
import java.util.List;

public class Element {
    private List<ResultMatch> before = new ArrayList<ResultMatch>();
    private int line;
    private String featureName = "";
    private String name = "";
    private String description = "";
    private String id = "";
    private List<ResultMatch> after = new ArrayList<ResultMatch>();
    private String type = "";
    private String keyword = "";
    private List<Step> steps = new ArrayList<Step>();
    private List<Tag> tags = new ArrayList<Tag>();
    private int featureIndex = 0;
    private transient int scenarioIndex = 0;

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<ResultMatch> getBefore() {
        return this.before;
    }

    public void setBefore(List<ResultMatch> before) {
        this.before = before;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getName() {
        return !this.name.isEmpty() ? this.name : "[Unnamed]";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<ResultMatch> getAfter() {
        return this.after;
    }

    public void setAfter(List<ResultMatch> after) {
        this.after = after;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public boolean isScenario() {
        return this.type.equals("scenario");
    }

    public boolean isFailed() {
        return this.getStatus() == Status.FAILED;
    }

    public boolean isPassed() {
        return this.getStatus() == Status.PASSED;
    }

    public boolean isSkipped() {
        return this.getStatus() == Status.SKIPPED;
    }

    public Status getStatus() {
        int totalSteps = this.steps.size();
        if (totalSteps == 0) {
            return Status.SKIPPED;
        }
        for (ResultMatch beforeHook : this.before) {
            if (!beforeHook.isFailed()) continue;
            return Status.FAILED;
        }
        for (ResultMatch afterHook : this.after) {
            if (!afterHook.isFailed()) continue;
            return Status.FAILED;
        }
        for (Status status : Status.values()) {
            long count = 0L;
            for (Step step : this.steps) {
                if (step.getStatus() == status) {
                    ++count;
                }
                for (ResultMatch beforeStepHook : step.getBefore()) {
                    if (!beforeStepHook.isFailed()) continue;
                    return Status.FAILED;
                }
                for (ResultMatch afterStepHook : step.getAfter()) {
                    if (!afterStepHook.isFailed()) continue;
                    return Status.FAILED;
                }
            }
            int stepNumber = (int)count;
            if (totalSteps != stepNumber) continue;
            if (status != Status.UNDEFINED) {
                return status;
            }
            return Status.SKIPPED;
        }
        if (this.getTotalNumberOfPassedSteps() >= 0 && this.getTotalNumberOfSkippedSteps() + this.getTotalNumberOfPassedSteps() == this.getTotalNumberOfSteps()) {
            return Status.PASSED;
        }
        if (this.getTotalNumberOfSkippedSteps() == totalSteps) {
            return Status.SKIPPED;
        }
        return Status.FAILED;
    }

    public int getScenarioIndex() {
        return this.scenarioIndex;
    }

    public void setScenarioIndex(int scenarioIndex) {
        this.scenarioIndex = scenarioIndex;
    }

    public int getTotalNumberOfSteps() {
        return this.getSteps().size();
    }

    public int getTotalNumberOfPassedSteps() {
        return this.getNumberOfStepsWithStatus(Status.PASSED);
    }

    public int getTotalNumberOfFailedSteps() {
        return this.getNumberOfStepsWithStatus(Status.FAILED) + this.getNumberOfStepsWithStatus(Status.UNDEFINED) + this.getNumberOfStepsWithStatus(Status.AMBIGUOUS);
    }

    public int getTotalNumberOfSkippedSteps() {
        return this.getNumberOfStepsWithStatus(Status.SKIPPED) + this.getNumberOfStepsWithStatus(Status.PENDING);
    }

    private int getNumberOfStepsWithStatus(Status status) {
        return (int)this.getSteps().stream().filter(step -> step.getStatus() == status).count();
    }

    public long getTotalDuration() {
        long totalDurationMicroseconds = 0L;
        for (ResultMatch beforeStep : this.before) {
            totalDurationMicroseconds += beforeStep.getResult().getDuration();
        }
        for (Step step : this.steps) {
            totalDurationMicroseconds += step.getResult().getDuration();
        }
        for (ResultMatch afterStep : this.after) {
            totalDurationMicroseconds += afterStep.getResult().getDuration();
        }
        return totalDurationMicroseconds;
    }

    public String returnTotalDurationString() {
        return RenderingUtils.convertMicrosecondsToTimeString(this.getTotalDuration());
    }

    public boolean hasHooks() {
        return this.getBefore().size() > 0 || this.getAfter().size() > 0;
    }

    public boolean hasDocStrings() {
        for (Step step : this.steps) {
            if (step.getDocString() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasStepHooks() {
        for (Step step : this.steps) {
            if (step.getBefore().size() > 0) {
                return true;
            }
            if (step.getAfter().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public List<ResultMatch> getAllResultMatches() {
        ArrayList<ResultMatch> resultMatches = new ArrayList<ResultMatch>(this.getBefore());
        resultMatches.addAll(this.getSteps());
        resultMatches.addAll(this.getAfter());
        return resultMatches;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureIndex(int featureIndex) {
        this.featureIndex = featureIndex;
    }

    public int getFeatureIndex() {
        return this.featureIndex;
    }
}

