/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering;

import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;

public class RenderingUtils {
    private static final int MICROSECOND_FACTOR = 1000000;
    private static final Pattern URL_PATTERN = Pattern.compile("(ftp|http|https)://(\\w+:?\\w*@)?(\\S+)(:[0-9]+)?(/|/([\\w#!:.?+=&%@\\-/]))?");

    public static String convertMicrosecondsToTimeString(long microseconds) {
        Duration durationMilliseconds = Duration.ofMillis(microseconds / 1000000L);
        long minutes = durationMilliseconds.toMinutes();
        long seconds = durationMilliseconds.minusMinutes(minutes).getSeconds();
        long milliseconds = durationMilliseconds.minusMinutes(minutes).minusSeconds(seconds).toMillis();
        return String.format("%dm %02ds %03dms", minutes, seconds, milliseconds);
    }

    public static long convertMicrosecondsToMilliseconds(long microseconds) {
        return microseconds / 1000000L;
    }

    static String prettifyHtml(String html) {
        return Jsoup.parse((String)html).toString().trim();
    }

    public static String getPluginVersion() {
        String version = RenderingUtils.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "unknown";
        }
        return version;
    }

    public static String escapeHTML(String sourceString) {
        StringBuilder stringBuilder = new StringBuilder(Math.max(16, sourceString.length()));
        for (int i = 0; i < sourceString.length(); ++i) {
            char character = sourceString.charAt(i);
            if (character > '\u007f' || character == '\"' || character == '<' || character == '>' || character == '&') {
                stringBuilder.append("&#");
                stringBuilder.append((int)character);
                stringBuilder.append(';');
                continue;
            }
            stringBuilder.append(character);
        }
        return stringBuilder.toString();
    }

    public static String turnUrlsIntoLinks(String sourceString) {
        Matcher matcher = URL_PATTERN.matcher(sourceString);
        String targetString = sourceString;
        while (matcher.find()) {
            String found = matcher.group();
            targetString = targetString.replaceFirst(Pattern.quote(found), "<a href='" + found + "' target='_blank'>" + found + "</a>");
        }
        return targetString;
    }
}

