/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import javax.inject.Singleton;

@Singleton
public class TemplateConfiguration {
    private Configuration cfg;

    void init(String basePath) {
        this.cfg = new Configuration(Configuration.VERSION_2_3_28);
        this.cfg.setClassForTemplateLoading(this.getClass(), basePath);
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setLogTemplateExceptions(false);
    }

    Template getTemplate(String templateName) throws CluecumberPluginException {
        Template template;
        try {
            template = this.cfg.getTemplate(templateName + ".ftl");
        }
        catch (Exception e) {
            throw new CluecumberPluginException("Template '" + templateName + "' was not found or not parsable: " + e.getMessage());
        }
        return template;
    }
}

