/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.pojos.pagecollections;

import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.json.pojo.Tag;
import com.trivago.cluecumber.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.SummaryPageCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AllTagsPageCollection
extends SummaryPageCollection {
    private Map<Tag, ResultCount> tagResultCounts = new HashMap<Tag, ResultCount>();
    private Set<Object> totalFailedTaggedScenarios = new HashSet<Object>();
    private Set<Object> totalPassedTaggedScenarios = new HashSet<Object>();
    private Set<Object> totalSkippedTaggedScenarios = new HashSet<Object>();

    public AllTagsPageCollection(List<Report> reports) {
        super("Tag Summary");
        this.calculateTagResultCounts(reports);
    }

    public Map<Tag, ResultCount> getTagResultCounts() {
        return this.tagResultCounts;
    }

    public Set<Tag> getTags() {
        return this.tagResultCounts.keySet();
    }

    public int getTotalNumberOfTags() {
        return this.tagResultCounts.size();
    }

    public int getTotalNumberOfTaggedScenarios() {
        return this.getTotalNumberOfPassedTags() + this.getTotalNumberOfFailedTags() + this.getTotalNumberOfSkippedTags();
    }

    public int getTotalNumberOfPassedTags() {
        return this.totalPassedTaggedScenarios.size();
    }

    public int getTotalNumberOfFailedTags() {
        return this.totalFailedTaggedScenarios.size();
    }

    public int getTotalNumberOfSkippedTags() {
        return this.totalSkippedTaggedScenarios.size();
    }

    private void calculateTagResultCounts(List<Report> reports) {
        if (reports == null) {
            return;
        }
        for (Report report : reports) {
            for (Element element : report.getElements()) {
                for (Tag tag : element.getTags()) {
                    ResultCount tagResultCount = this.tagResultCounts.getOrDefault(tag, new ResultCount());
                    Status status = element.getStatus();
                    this.updateResultCount(tagResultCount, element.getStatus());
                    switch (status) {
                        case FAILED: {
                            this.totalFailedTaggedScenarios.add(element.getScenarioIndex());
                            break;
                        }
                        case PASSED: {
                            this.totalPassedTaggedScenarios.add(element.getScenarioIndex());
                            break;
                        }
                        case SKIPPED: {
                            this.totalSkippedTaggedScenarios.add(element.getScenarioIndex());
                        }
                    }
                    this.tagResultCounts.put(tag, tagResultCount);
                }
            }
        }
    }
}

