/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.json.pojo;

import com.google.gson.annotations.SerializedName;
import com.trivago.cluecumber.json.pojo.Argument;
import com.trivago.cluecumber.json.pojo.DocString;
import com.trivago.cluecumber.json.pojo.ResultMatch;
import com.trivago.cluecumber.json.pojo.Row;
import com.trivago.cluecumber.rendering.RenderingUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Step
extends ResultMatch {
    private List<ResultMatch> before = new ArrayList<ResultMatch>();
    private int line;
    private String name = "";
    private String keyword = "";
    private List<Row> rows = new ArrayList<Row>();
    private List<ResultMatch> after = new ArrayList<ResultMatch>();
    @SerializedName(value="doc_string")
    private DocString docString;

    public List<ResultMatch> getBefore() {
        return this.before;
    }

    public void setBefore(List<ResultMatch> before) {
        this.before = before;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getName() {
        return !this.name.isEmpty() ? this.name : "[Unnamed]";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String returnNameWithArguments() {
        String tmpName = this.getName();
        List<Argument> arguments = this.getArguments();
        for (int i = arguments.size() - 1; i >= 0; --i) {
            String argument = arguments.get(i).getVal();
            if (argument == null) continue;
            tmpName = tmpName.replaceFirst(Pattern.quote(argument), Matcher.quoteReplacement("<strong>" + argument + "</strong>"));
        }
        return tmpName;
    }

    public String returnNameWithArgumentPlaceholders() {
        String tmpName = this.getName();
        List<Argument> arguments = this.getArguments();
        for (int i = arguments.size() - 1; i >= 0; --i) {
            String argument = arguments.get(i).getVal();
            if (argument == null) continue;
            tmpName = tmpName.replaceFirst(Pattern.quote(argument), Matcher.quoteReplacement("{}"));
        }
        return tmpName;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public List<ResultMatch> getAfter() {
        return this.after;
    }

    public void setAfter(List<ResultMatch> after) {
        this.after = after;
    }

    public DocString getDocString() {
        return this.docString;
    }

    public void setDocString(DocString docString) {
        this.docString = docString;
    }

    public long getTotalDuration() {
        long totalDurationNanoseconds = 0L;
        for (ResultMatch beforeStep : this.before) {
            totalDurationNanoseconds += beforeStep.getResult().getDuration();
        }
        totalDurationNanoseconds += this.getResult().getDuration();
        for (ResultMatch afterStep : this.after) {
            totalDurationNanoseconds += afterStep.getResult().getDuration();
        }
        return totalDurationNanoseconds;
    }

    public String returnTotalDurationString() {
        return RenderingUtils.convertNanosecondsToTimeString(this.getTotalDuration());
    }

    public String getUrlFriendlyName() {
        return Integer.toString(this.hashCode()).replace("-", "0");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Step step = (Step)o;
        return Objects.equals(this.getGlueMethodName(), step.getGlueMethodName());
    }

    public int hashCode() {
        return Objects.hash(this.getGlueMethodName());
    }
}

