/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.pojos.pagecollections;

import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.json.pojo.Step;
import com.trivago.cluecumber.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.rendering.pages.pojos.Times;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.ScenarioSummaryPageCollection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AllStepsPageCollection
extends ScenarioSummaryPageCollection {
    private Map<Step, ResultCount> stepResultCounts = new HashMap<Step, ResultCount>();
    private Map<Step, Times> stepTimes = new HashMap<Step, Times>();

    public AllStepsPageCollection(List<Report> reports) {
        super("Step Summary");
        this.calculateStepResultCounts(reports);
    }

    public Map<Step, ResultCount> getStepResultCounts() {
        return this.stepResultCounts;
    }

    public Set<Step> getSteps() {
        return this.stepResultCounts.keySet();
    }

    public int getTotalNumberOfSteps() {
        return this.stepResultCounts.size();
    }

    public String getMinimumTimeFromStep(Step step) {
        return this.stepTimes.get(step).getMinimumTime();
    }

    public String getMaximumTimeFromStep(Step step) {
        return this.stepTimes.get(step).getMaximumTime();
    }

    public String getAverageTimeFromStep(Step step) {
        return this.stepTimes.get(step).getAverageTime();
    }

    private void calculateStepResultCounts(List<Report> reports) {
        if (reports == null) {
            return;
        }
        for (Report report : reports) {
            for (Element element : report.getElements()) {
                for (Step step : element.getSteps()) {
                    ResultCount stepResultCount = this.stepResultCounts.getOrDefault(step, new ResultCount());
                    this.updateResultCount(stepResultCount, step.getStatus());
                    this.stepResultCounts.put(step, stepResultCount);
                    Times stepTimes = this.stepTimes.getOrDefault(step, new Times());
                    stepTimes.addTime(step.getResult().getDuration());
                    this.stepTimes.put(step, stepTimes);
                    this.addScenarioIndexByStatus(element.getStatus(), element.getScenarioIndex());
                }
            }
        }
    }
}

