/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.json;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.trivago.cluecumber.constants.MimeType;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.json.processors.ElementJsonPostProcessor;
import com.trivago.cluecumber.json.processors.ReportJsonPostProcessor;
import io.gsonfire.GsonFireBuilder;
import io.gsonfire.PostProcessor;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class JsonPojoConverter {
    private final Gson gsonParserWithProcessors;

    @Inject
    public JsonPojoConverter(ReportJsonPostProcessor reportJsonPostProcessor, ElementJsonPostProcessor elementJsonPostProcessor) {
        GsonFireBuilder builder = new GsonFireBuilder().registerPostProcessor(Report.class, (PostProcessor)reportJsonPostProcessor).registerPostProcessor(Element.class, (PostProcessor)elementJsonPostProcessor).enumDefaultValue(MimeType.class, (Enum)MimeType.UNKNOWN);
        this.gsonParserWithProcessors = builder.createGson();
    }

    public Report[] convertJsonToReportPojos(String json) throws CluecumberPluginException {
        Report[] reports;
        try {
            reports = (Report[])this.gsonParserWithProcessors.fromJson(json, Report[].class);
        }
        catch (JsonParseException e) {
            throw new CluecumberPluginException(e.getMessage());
        }
        return reports;
    }
}

