/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.properties;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.filesystem.FileIO;
import com.trivago.cluecumber.properties.LinkedProperties;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PropertiesFileLoader {
    private FileIO fileIO;

    @Inject
    public PropertiesFileLoader(FileIO fileIO) {
        this.fileIO = fileIO;
    }

    LinkedHashMap<String, String> loadPropertiesMap(String propertiesFilePath) throws CluecumberPluginException {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        String content = this.fileIO.readContentFromFile(propertiesFilePath);
        LinkedProperties properties = new LinkedProperties();
        try {
            properties.load(new StringReader(content));
        }
        catch (IOException e) {
            throw new CluecumberPluginException("Could not parse properties file '': " + e.getMessage());
        }
        for (Map.Entry<Object, Object> propertyEntry : properties.entrySet()) {
            propertiesMap.put((String)propertyEntry.getKey(), (String)propertyEntry.getValue());
        }
        return propertiesMap;
    }
}

