/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.properties;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.exceptions.filesystem.MissingFileException;
import com.trivago.cluecumber.exceptions.properties.WrongOrMissingPropertyException;
import com.trivago.cluecumber.filesystem.FileIO;
import com.trivago.cluecumber.logging.CluecumberLogger;
import com.trivago.cluecumber.properties.PropertiesFileLoader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PropertyManager {
    private final CluecumberLogger logger;
    private FileIO fileIO;
    private PropertiesFileLoader propertiesFileLoader;
    private String sourceJsonReportDirectory;
    private String generatedHtmlReportDirectory;
    private Map<String, String> customParameters = new LinkedHashMap<String, String>();
    private boolean failScenariosOnPendingOrUndefinedSteps;
    private boolean expandBeforeAfterHooks;
    private boolean expandStepHooks;
    private boolean expandDocStrings;
    private String customCssFile;
    private String customParametersFile;

    @Inject
    public PropertyManager(CluecumberLogger logger, FileIO fileIO, PropertiesFileLoader propertiesFileLoader) {
        this.logger = logger;
        this.fileIO = fileIO;
        this.propertiesFileLoader = propertiesFileLoader;
    }

    public String getSourceJsonReportDirectory() {
        return this.sourceJsonReportDirectory;
    }

    public void setSourceJsonReportDirectory(String sourceJsonReportDirectory) throws WrongOrMissingPropertyException {
        if (!this.isSet(sourceJsonReportDirectory)) {
            throw new WrongOrMissingPropertyException("sourceJsonReportDirectory");
        }
        this.sourceJsonReportDirectory = sourceJsonReportDirectory;
    }

    public String getGeneratedHtmlReportDirectory() {
        return this.generatedHtmlReportDirectory;
    }

    public void setGeneratedHtmlReportDirectory(String generatedHtmlReportDirectory) throws WrongOrMissingPropertyException {
        if (!this.isSet(generatedHtmlReportDirectory)) {
            throw new WrongOrMissingPropertyException("generatedHtmlReportDirectory");
        }
        this.generatedHtmlReportDirectory = generatedHtmlReportDirectory;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public void setCustomParameters(Map<String, String> customParameters) {
        this.customParameters.putAll(customParameters);
    }

    String getCustomParametersFile() {
        return this.customParametersFile;
    }

    public void setCustomParametersFile(String customParametersFile) throws CluecumberPluginException {
        if (this.isSet(customParametersFile) && !this.fileIO.isExistingFile(customParametersFile)) {
            throw new MissingFileException(customParametersFile);
        }
        this.customParametersFile = customParametersFile;
        LinkedHashMap<String, String> customParameters = this.propertiesFileLoader.loadPropertiesMap(customParametersFile);
        this.customParameters.putAll(customParameters);
    }

    public boolean isFailScenariosOnPendingOrUndefinedSteps() {
        return this.failScenariosOnPendingOrUndefinedSteps;
    }

    public void setFailScenariosOnPendingOrUndefinedSteps(boolean failScenariosOnPendingOrUndefinedSteps) {
        this.failScenariosOnPendingOrUndefinedSteps = failScenariosOnPendingOrUndefinedSteps;
    }

    public boolean isExpandBeforeAfterHooks() {
        return this.expandBeforeAfterHooks;
    }

    public void setExpandBeforeAfterHooks(boolean expandBeforeAfterHooks) {
        this.expandBeforeAfterHooks = expandBeforeAfterHooks;
    }

    public boolean isExpandStepHooks() {
        return this.expandStepHooks;
    }

    public void setExpandStepHooks(boolean expandStepHooks) {
        this.expandStepHooks = expandStepHooks;
    }

    public boolean isExpandDocStrings() {
        return this.expandDocStrings;
    }

    public void setExpandDocStrings(boolean expandDocStrings) {
        this.expandDocStrings = expandDocStrings;
    }

    public String getCustomCssFile() {
        return this.customCssFile;
    }

    public void setCustomCssFile(String customCssFile) throws MissingFileException {
        if (this.isSet(customCssFile) && !this.fileIO.isExistingFile(customCssFile)) {
            throw new MissingFileException(customCssFile);
        }
        this.customCssFile = customCssFile;
    }

    public void logProperties() {
        boolean customParametersFileExists;
        this.logger.info("- source JSON report directory     : " + this.sourceJsonReportDirectory);
        this.logger.info("- generated HTML report directory  : " + this.generatedHtmlReportDirectory);
        boolean bl = customParametersFileExists = this.customParametersFile != null && !this.customParametersFile.isEmpty();
        if (customParametersFileExists) {
            this.logger.logSeparator();
            this.logger.info("- custom parameters file           : " + this.customParametersFile);
        }
        if (this.customParameters != null && !this.customParameters.isEmpty()) {
            if (!customParametersFileExists) {
                this.logger.logSeparator();
            }
            for (Map.Entry<String, String> entry : this.customParameters.entrySet()) {
                this.logger.info("- custom parameter                 : " + entry.getKey() + " -> " + entry.getValue());
            }
        }
        this.logger.logSeparator();
        this.logger.info("- fail pending/undefined scenarios : " + this.failScenariosOnPendingOrUndefinedSteps);
        this.logger.info("- expand before/after hooks        : " + this.expandBeforeAfterHooks);
        this.logger.info("- expand step hooks                : " + this.expandStepHooks);
        this.logger.info("- expand doc strings               : " + this.expandDocStrings);
        if (this.customCssFile != null && !this.customCssFile.isEmpty()) {
            this.logger.info("- custom CSS file              : " + this.customCssFile);
        }
        this.logger.logSeparator();
    }

    private boolean isSet(String string) {
        return string != null && !string.trim().isEmpty();
    }
}

