/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.filesystem.FileSystemManager;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.rendering.pages.visitors.FeatureVisitor;
import com.trivago.cluecumber.rendering.pages.visitors.PageVisitor;
import com.trivago.cluecumber.rendering.pages.visitors.ScenarioVisitor;
import com.trivago.cluecumber.rendering.pages.visitors.StepVisitor;
import com.trivago.cluecumber.rendering.pages.visitors.TagVisitor;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ReportGenerator {
    private final PropertyManager propertyManager;
    private final FileSystemManager fileSystemManager;
    private List<PageVisitor> visitors = new ArrayList<PageVisitor>();

    @Inject
    public ReportGenerator(PropertyManager propertyManager, FileSystemManager fileSystemManager, ScenarioVisitor scenarioVisitor, FeatureVisitor featureVisitor, TagVisitor tagVisitor, StepVisitor stepVisitor) {
        this.propertyManager = propertyManager;
        this.fileSystemManager = fileSystemManager;
        this.visitors.add(scenarioVisitor);
        this.visitors.add(featureVisitor);
        this.visitors.add(tagVisitor);
        this.visitors.add(stepVisitor);
    }

    public void generateReport(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberPluginException {
        this.copyReportAssets();
        for (PageVisitor visitor : this.visitors) {
            allScenariosPageCollection.accept(visitor);
        }
    }

    private void copyReportAssets() throws CluecumberPluginException {
        String reportDirectory = this.propertyManager.getGeneratedHtmlReportDirectory();
        this.fileSystemManager.createDirectory(reportDirectory);
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages");
        this.fileSystemManager.createDirectory(reportDirectory + "/" + "pages" + "/" + "scenario-detail");
        this.fileSystemManager.createDirectory(reportDirectory + "/" + "pages" + "/" + "feature-scenarios");
        this.fileSystemManager.createDirectory(reportDirectory + "/" + "pages" + "/" + "tag-scenarios");
        this.fileSystemManager.createDirectory(reportDirectory + "/" + "pages" + "/" + "step-scenarios");
        this.fileSystemManager.createDirectory(reportDirectory + "/css");
        this.copyFileFromJarToReportDirectory("/css/bootstrap.min.css");
        this.copyFileFromJarToReportDirectory("/css/cluecumber.css");
        this.copyFileFromJarToReportDirectory("/css/datatables.min.css");
        this.copyFileFromJarToReportDirectory("/css/jquery.fancybox.min.css");
        this.copyFileFromJarToReportDirectory("/css/dataTables.bootstrap4.min.css");
        String customCss = this.propertyManager.getCustomCssFile();
        if (customCss != null && !customCss.isEmpty()) {
            this.fileSystemManager.copyResource(customCss, reportDirectory + "/css/cluecumber_custom.css");
        } else {
            this.copyFileFromJarToReportDirectory("/css/cluecumber_custom.css");
        }
        this.fileSystemManager.createDirectory(reportDirectory + "/font");
        this.copyFileFromJarToReportDirectory("/font/cluecumber.eot");
        this.copyFileFromJarToReportDirectory("/font/cluecumber.svg");
        this.copyFileFromJarToReportDirectory("/font/cluecumber.ttf");
        this.copyFileFromJarToReportDirectory("/font/cluecumber.woff");
        this.copyFileFromJarToReportDirectory("/font/cluecumber.woff2");
        this.fileSystemManager.createDirectory(reportDirectory + "/js");
        this.copyFileFromJarToReportDirectory("/js/jquery.min.js");
        this.copyFileFromJarToReportDirectory("/js/bootstrap.min.js");
        this.copyFileFromJarToReportDirectory("/js/popper.min.js");
        this.copyFileFromJarToReportDirectory("/js/Chart.bundle.min.js");
        this.copyFileFromJarToReportDirectory("/js/datatables.min.js");
        this.copyFileFromJarToReportDirectory("/js/jquery.fancybox.min.js");
    }

    private void copyFileFromJarToReportDirectory(String fileName) throws CluecumberPluginException {
        this.fileSystemManager.copyResourceFromJar("/template" + fileName, this.propertyManager.getGeneratedHtmlReportDirectory() + fileName);
    }
}

