/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderering;

import com.trivago.cluecumber.constants.Charts;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.json.pojo.Step;
import com.trivago.cluecumber.json.pojo.Tag;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Data;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Dataset;
import com.trivago.cluecumber.rendering.pages.pojos.CustomParameter;
import com.trivago.cluecumber.rendering.pages.pojos.Feature;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.PageRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AllScenariosPageRenderer
extends PageRenderer {
    private final PropertyManager propertyManager;

    @Inject
    AllScenariosPageRenderer(ChartJsonConverter chartJsonConverter, PropertyManager propertyManager) {
        super(chartJsonConverter);
        this.propertyManager = propertyManager;
    }

    public String getRenderedContent(AllScenariosPageCollection allScenariosPageCollection, Template template) throws CluecumberPluginException {
        AllScenariosPageCollection allScenariosPageCollectionClone = this.getAllScenariosPageCollectionClone(allScenariosPageCollection);
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        this.addCustomParametersToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone);
    }

    public String getRenderedContentByTagFilter(AllScenariosPageCollection allScenariosPageCollection, Template template, Tag tag) throws CluecumberPluginException {
        AllScenariosPageCollection allScenariosPageCollectionClone = this.getAllScenariosPageCollectionClone(allScenariosPageCollection);
        allScenariosPageCollectionClone.setTagFilter(tag);
        for (Report report : allScenariosPageCollectionClone.getReports()) {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element element : report.getElements()) {
                if (!element.getTags().contains(tag)) continue;
                elements.add(element);
            }
            report.setElements(elements);
        }
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone);
    }

    public String getRenderedContentByStepFilter(AllScenariosPageCollection allScenariosPageCollection, Template template, Step step) throws CluecumberPluginException {
        AllScenariosPageCollection allScenariosPageCollectionClone = this.getAllScenariosPageCollectionClone(allScenariosPageCollection);
        allScenariosPageCollectionClone.setStepFilter(step);
        for (Report report : allScenariosPageCollectionClone.getReports()) {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element element : report.getElements()) {
                if (!element.getSteps().contains(step)) continue;
                elements.add(element);
            }
            report.setElements(elements);
        }
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone);
    }

    public String getRenderedContentByFeatureFilter(AllScenariosPageCollection allScenariosPageCollection, Template template, Feature feature) throws CluecumberPluginException {
        AllScenariosPageCollection allScenariosPageCollectionClone = this.getAllScenariosPageCollectionClone(allScenariosPageCollection);
        allScenariosPageCollectionClone.setFeatureFilter(feature);
        ArrayList<Report> reports = new ArrayList<Report>();
        for (Report report : allScenariosPageCollectionClone.getReports()) {
            if (report.getFeatureIndex() != feature.getIndex()) continue;
            reports.add(report);
        }
        Report[] reportArray = reports.toArray(new Report[0]);
        allScenariosPageCollectionClone.clearReports();
        allScenariosPageCollectionClone.addReports(reportArray);
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone);
    }

    private void addChartJsonToReportDetails(AllScenariosPageCollection allScenariosPageCollection) {
        Chart chart = new Chart();
        Data data = new Data();
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(Status.PASSED.getStatusString());
        labels.add(Status.FAILED.getStatusString());
        labels.add(Status.SKIPPED.getStatusString());
        data.setLabels(labels);
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        Dataset dataset = new Dataset();
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(allScenariosPageCollection.getTotalNumberOfPassedScenarios());
        values.add(allScenariosPageCollection.getTotalNumberOfFailedScenarios());
        values.add(allScenariosPageCollection.getTotalNumberOfSkippedScenarios());
        dataset.setData(values);
        datasets.add(dataset);
        ArrayList<String> backgroundColors = new ArrayList<String>();
        backgroundColors.add(Charts.Color.getChartColorStringByStatus(Status.PASSED));
        backgroundColors.add(Charts.Color.getChartColorStringByStatus(Status.FAILED));
        backgroundColors.add(Charts.Color.getChartColorStringByStatus(Status.SKIPPED));
        dataset.setBackgroundColor(backgroundColors);
        data.setDatasets(datasets);
        chart.setData(data);
        chart.setType(Charts.Type.pie);
        allScenariosPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }

    private void addCustomParametersToReportDetails(AllScenariosPageCollection allScenariosPageCollection) {
        Map<String, String> customParameterMap = this.propertyManager.getCustomParameters();
        if (customParameterMap == null || customParameterMap.isEmpty()) {
            return;
        }
        ArrayList<CustomParameter> customParameters = new ArrayList<CustomParameter>();
        for (Map.Entry<String, String> stringStringEntry : customParameterMap.entrySet()) {
            String value = stringStringEntry.getValue();
            if (value == null || value.trim().isEmpty()) continue;
            String key = stringStringEntry.getKey().replace("_", " ");
            CustomParameter customParameter = new CustomParameter(key, value);
            customParameters.add(customParameter);
        }
        allScenariosPageCollection.setCustomParameters(customParameters);
    }

    private AllScenariosPageCollection getAllScenariosPageCollectionClone(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberPluginException {
        AllScenariosPageCollection clone;
        try {
            clone = (AllScenariosPageCollection)allScenariosPageCollection.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CluecumberPluginException("Clone of AllScenariosPageCollection not supported: " + e.getMessage());
        }
        return clone;
    }
}

