/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderering;

import com.trivago.cluecumber.constants.Charts;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.json.pojo.Tag;
import com.trivago.cluecumber.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Axis;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Data;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Dataset;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Options;
import com.trivago.cluecumber.rendering.pages.charts.pojos.ScaleLabel;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Scales;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Ticks;
import com.trivago.cluecumber.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllTagsPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.PageRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AllTagsPageRenderer
extends PageRenderer {
    @Inject
    public AllTagsPageRenderer(ChartJsonConverter chartJsonConverter) {
        super(chartJsonConverter);
    }

    public String getRenderedContent(AllTagsPageCollection allTagsPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(allTagsPageCollection);
        return this.processedContent(template, allTagsPageCollection);
    }

    private void addChartJsonToReportDetails(AllTagsPageCollection allTagsPageCollection) {
        Chart chart = new Chart();
        Data data = new Data();
        chart.setData(data);
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        ArrayList<Integer> passed = new ArrayList<Integer>();
        ArrayList<Integer> failed = new ArrayList<Integer>();
        ArrayList<Integer> skipped = new ArrayList<Integer>();
        int maxY = 0;
        for (Map.Entry<Tag, ResultCount> entry : allTagsPageCollection.getTagResultCounts().entrySet()) {
            passed.add(entry.getValue().getPassed());
            failed.add(entry.getValue().getFailed());
            skipped.add(entry.getValue().getSkipped());
            maxY = entry.getValue().getTotal();
        }
        Dataset passedDataset = new Dataset();
        passedDataset.setLabel("passed");
        passedDataset.setData(passed);
        ArrayList<String> passedBG = new ArrayList<String>(Collections.nCopies(passed.size(), Charts.Color.getChartColorStringByStatus(Status.PASSED)));
        passedDataset.setBackgroundColor(passedBG);
        datasets.add(passedDataset);
        Dataset failedDataset = new Dataset();
        failedDataset.setLabel("failed");
        failedDataset.setData(failed);
        ArrayList<String> failedBG = new ArrayList<String>(Collections.nCopies(passed.size(), Charts.Color.getChartColorStringByStatus(Status.FAILED)));
        failedDataset.setBackgroundColor(failedBG);
        datasets.add(failedDataset);
        Dataset skippedDataset = new Dataset();
        skippedDataset.setLabel("skipped");
        skippedDataset.setData(skipped);
        ArrayList<String> skippedBG = new ArrayList<String>(Collections.nCopies(passed.size(), Charts.Color.getChartColorStringByStatus(Status.SKIPPED)));
        skippedDataset.setBackgroundColor(skippedBG);
        datasets.add(skippedDataset);
        data.setDatasets(datasets);
        ArrayList<String> keys = new ArrayList<String>();
        for (Tag tag : allTagsPageCollection.getTagResultCounts().keySet()) {
            keys.add(tag.getName());
        }
        data.setLabels(keys);
        Options options = new Options();
        Scales scales = new Scales();
        ArrayList<Axis> xAxes = new ArrayList<Axis>();
        Axis xAxis = new Axis();
        xAxis.setStacked(true);
        Ticks xTicks = new Ticks();
        xTicks.setDisplay(false);
        xAxis.setTicks(xTicks);
        ScaleLabel xScaleLabel = new ScaleLabel();
        xScaleLabel.setDisplay(true);
        xScaleLabel.setLabelString(allTagsPageCollection.getTotalNumberOfTags() + " Tag(s)");
        xAxis.setScaleLabel(xScaleLabel);
        xAxes.add(xAxis);
        scales.setxAxes(xAxes);
        ArrayList<Axis> yAxes = new ArrayList<Axis>();
        Axis yAxis = new Axis();
        yAxis.setStacked(true);
        Ticks yTicks = new Ticks();
        yAxis.setTicks(yTicks);
        ScaleLabel yScaleLabel = new ScaleLabel();
        yScaleLabel.setDisplay(true);
        yScaleLabel.setLabelString("Number of Scenarios");
        yAxis.setScaleLabel(yScaleLabel);
        yAxis.setStepSize(maxY);
        yAxes.add(yAxis);
        scales.setyAxes(yAxes);
        options.setScales(scales);
        chart.setOptions(options);
        chart.setType(Charts.Type.bar);
        allTagsPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }
}

