/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.visitors;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.filesystem.FileIO;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.ScenarioDetailsPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.AllScenariosPageRenderer;
import com.trivago.cluecumber.rendering.pages.renderering.ScenarioDetailsPageRenderer;
import com.trivago.cluecumber.rendering.pages.templates.TemplateEngine;
import com.trivago.cluecumber.rendering.pages.visitors.PageVisitor;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScenarioVisitor
implements PageVisitor {
    private final FileIO fileIO;
    private final TemplateEngine templateEngine;
    private final PropertyManager propertyManager;
    private final AllScenariosPageRenderer allScenariosPageRenderer;
    private final ScenarioDetailsPageRenderer scenarioDetailsPageRenderer;

    @Inject
    public ScenarioVisitor(FileIO fileIO, TemplateEngine templateEngine, PropertyManager propertyManager, AllScenariosPageRenderer allScenariosPageRenderer, ScenarioDetailsPageRenderer scenarioDetailsPageRenderer) {
        this.fileIO = fileIO;
        this.templateEngine = templateEngine;
        this.propertyManager = propertyManager;
        this.allScenariosPageRenderer = allScenariosPageRenderer;
        this.scenarioDetailsPageRenderer = scenarioDetailsPageRenderer;
    }

    @Override
    public void visit(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberPluginException {
        this.fileIO.writeContentToFile(this.allScenariosPageRenderer.getRenderedContent(allScenariosPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.ALL_SCENARIOS)), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "index" + ".html");
        this.fileIO.writeContentToFile(this.allScenariosPageRenderer.getRenderedContent(allScenariosPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.SCENARIO_SEQUENCE)), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/" + "scenario-sequence" + ".html");
        for (Report report : allScenariosPageCollection.getReports()) {
            for (Element element : report.getElements()) {
                ScenarioDetailsPageCollection scenarioDetailsPageCollection = new ScenarioDetailsPageCollection(element);
                this.fileIO.writeContentToFile(this.scenarioDetailsPageRenderer.getRenderedContent(scenarioDetailsPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.SCENARIO_DETAILS)), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/scenario-detail/scenario_" + element.getScenarioIndex() + ".html");
            }
        }
    }
}

