/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.charts;

import com.trivago.cluecumber.constants.ChartConfiguration;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Data;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Dataset;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Options;
import java.util.ArrayList;
import java.util.List;

public class PieChartBuilder {
    private final ChartConfiguration chartConfiguration;
    private List<ValueSet> valueSets;

    public PieChartBuilder(ChartConfiguration chartConfiguration) {
        this.chartConfiguration = chartConfiguration;
        this.valueSets = new ArrayList<ValueSet>();
    }

    public PieChartBuilder addValue(int value, Status status) {
        String color = this.chartConfiguration.getColorRgbaStringByStatus(status);
        this.valueSets.add(new ValueSet(value, color));
        return this;
    }

    public Chart build() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        ArrayList<String> colors = new ArrayList<String>();
        for (ValueSet valueSet : this.valueSets) {
            values.add(valueSet.value);
            colors.add(valueSet.color);
        }
        Dataset dataset = new Dataset();
        dataset.setBackgroundColor(colors);
        dataset.setData(values);
        Data data = new Data();
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(Status.PASSED.getStatusString());
        labels.add(Status.FAILED.getStatusString());
        labels.add(Status.SKIPPED.getStatusString());
        data.setLabels(labels);
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        datasets.add(dataset);
        data.setDatasets(datasets);
        Chart chart = new Chart();
        chart.setData(data);
        Options options = new Options();
        ArrayList<String> events = new ArrayList<String>();
        events.add("click");
        events.add("mousemove");
        options.setEvents(events);
        chart.setOptions(options);
        chart.setType(ChartConfiguration.Type.pie);
        return chart;
    }

    private class ValueSet {
        private final int value;
        private final String color;

        ValueSet(int value, String color) {
            this.value = value;
            this.color = color;
        }
    }
}

