/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderering;

import com.trivago.cluecumber.constants.ChartConfiguration;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.json.pojo.Step;
import com.trivago.cluecumber.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.rendering.pages.charts.StackedBarChartBuilder;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllStepsPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.PageRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class AllStepsPageRenderer
extends PageRenderer {
    private final ChartConfiguration chartConfiguration;

    @Inject
    public AllStepsPageRenderer(ChartJsonConverter chartJsonConverter, ChartConfiguration chartConfiguration) {
        super(chartJsonConverter);
        this.chartConfiguration = chartConfiguration;
    }

    public String getRenderedContent(AllStepsPageCollection allStepsPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(allStepsPageCollection);
        return this.processedContent(template, allStepsPageCollection);
    }

    private void addChartJsonToReportDetails(AllStepsPageCollection allTagsPageCollection) {
        ArrayList<Integer> passed = new ArrayList<Integer>();
        ArrayList<Integer> failed = new ArrayList<Integer>();
        ArrayList<Integer> skipped = new ArrayList<Integer>();
        allTagsPageCollection.getStepResultCounts().forEach((key, value) -> {
            passed.add(value.getPassed());
            failed.add(value.getFailed());
            skipped.add(value.getSkipped());
        });
        List<String> keys = allTagsPageCollection.getStepResultCounts().keySet().stream().map(Step::returnNameWithArgumentPlaceholders).collect(Collectors.toList());
        Chart chart = new StackedBarChartBuilder(this.chartConfiguration).setLabels(keys).setxAxisLabel(allTagsPageCollection.getTotalNumberOfSteps() + " Steps").setyAxisLabel("Number of Usages").addValues(passed, Status.PASSED).addValues(failed, Status.FAILED).addValues(skipped, Status.SKIPPED).build();
        allTagsPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }
}

