/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.filesystem;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.exceptions.filesystem.PathCreationException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Singleton
public class FileSystemManager {
    public List<Path> getJsonFilePaths(String sourcePath) throws CluecumberPluginException {
        List<Path> jsonFilePaths;
        try {
            jsonFilePaths = Files.walk(Paths.get(sourcePath, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().toLowerCase().endsWith(".json")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CluecumberPluginException("Unable to traverse JSON files in " + sourcePath);
        }
        return jsonFilePaths;
    }

    public void createDirectory(String dirName) throws PathCreationException {
        File directory = new File(dirName);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new PathCreationException(dirName);
        }
    }

    public void copyResourceFromJar(String resourceName, String destination) throws CluecumberPluginException {
        int BYTE_BLOCK = 4096;
        try (InputStream inputStream = this.getClass().getResourceAsStream(resourceName);){
            byte[] buffer = new byte[4096];
            try (FileOutputStream outputStream = new FileOutputStream(destination);){
                int readBytes;
                while ((readBytes = inputStream.read(buffer)) > 0) {
                    ((OutputStream)outputStream).write(buffer, 0, readBytes);
                }
            }
            catch (Exception e) {
                throw new CluecumberPluginException("Cannot write resource '" + resourceName + "': " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new CluecumberPluginException("Cannot process resource '" + resourceName + "': " + e.getMessage());
        }
    }

    public void copyResource(String source, String destination) throws CluecumberPluginException {
        Path sourcePath = Paths.get(source, new String[0]);
        Path destinationPath = Paths.get(destination, new String[0]);
        try {
            Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new CluecumberPluginException("Cannot copy resource '" + source + "': " + e.getMessage());
        }
    }
}

