/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderering;

import com.trivago.cluecumber.constants.ChartConfiguration;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.ResultMatch;
import com.trivago.cluecumber.json.pojo.Step;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.rendering.pages.charts.StackedBarChartBuilder;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.ScenarioDetailsPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.PageRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScenarioDetailsPageRenderer
extends PageRenderer {
    private final ChartConfiguration chartConfiguration;
    private PropertyManager propertyManager;

    @Inject
    public ScenarioDetailsPageRenderer(ChartJsonConverter chartJsonConverter, ChartConfiguration chartConfiguration, PropertyManager propertyManager) {
        super(chartJsonConverter);
        this.chartConfiguration = chartConfiguration;
        this.propertyManager = propertyManager;
    }

    public String getRenderedContent(ScenarioDetailsPageCollection scenarioDetailsPageCollection, Template template) throws CluecumberPluginException {
        scenarioDetailsPageCollection.setExpandBeforeAfterHooks(this.propertyManager.isExpandBeforeAfterHooks());
        scenarioDetailsPageCollection.setExpandStepHooks(this.propertyManager.isExpandStepHooks());
        scenarioDetailsPageCollection.setExpandDocStrings(this.propertyManager.isExpandDocStrings());
        this.addChartJsonToReportDetails(scenarioDetailsPageCollection);
        return this.processedContent(template, scenarioDetailsPageCollection);
    }

    private void addChartJsonToReportDetails(ScenarioDetailsPageCollection scenarioDetailsPageCollection) {
        Element element = scenarioDetailsPageCollection.getElement();
        ArrayList<String> labels = new ArrayList<String>();
        element.getBefore().stream().map(ResultMatch::getGlueMethodName).forEach(labels::add);
        element.getSteps().stream().map(Step::getName).forEach(labels::add);
        element.getAfter().stream().map(ResultMatch::getGlueMethodName).forEach(labels::add);
        List<Integer> passedValues = this.getValuesByStatus(element, Status.PASSED);
        List<Integer> failedValues = this.getValuesByStatus(element, Status.FAILED);
        List<Integer> skippedValues = this.getValuesByStatus(element, Status.SKIPPED);
        int passedMax = passedValues.stream().collect(Collectors.summarizingInt(Integer::intValue)).getMax();
        int failedMax = failedValues.stream().collect(Collectors.summarizingInt(Integer::intValue)).getMax();
        int skippedMax = skippedValues.stream().collect(Collectors.summarizingInt(Integer::intValue)).getMax();
        Integer maximumValue = Collections.max(Arrays.asList(passedMax, failedMax, skippedMax));
        Chart chart = new StackedBarChartBuilder(this.chartConfiguration).setxAxisLabel("Steps").setyAxisLabel("Step Runtime (seconds)").setyAxisStepSize(maximumValue).setLabels(labels).setStacked(false).addValues(passedValues, Status.PASSED).addValues(failedValues, Status.FAILED).addValues(skippedValues, Status.SKIPPED).build();
        scenarioDetailsPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }

    private List<Integer> getValuesByStatus(Element element, Status status) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        element.getAllResultMatches().forEach(resultMatch -> {
            if (resultMatch.getConsolidatedStatus() == status) {
                values.add((int)resultMatch.getResult().getDurationInMilliseconds() / 1000);
            } else {
                values.add(0);
            }
        });
        return values;
    }
}

