/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.json.processors;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.json.pojo.Tag;
import io.gsonfire.PostProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ReportJsonPostProcessor
implements PostProcessor<Report> {
    private final List<String> featureUris = new ArrayList<String>();

    @Inject
    public ReportJsonPostProcessor() {
    }

    public void postDeserialize(Report report, JsonElement jsonElement, Gson gson) {
        this.addFeatureIndex(report);
        this.addFeatureInformationToScenarios(report);
        this.mergeBackgroundScenarios(report);
    }

    private void addFeatureInformationToScenarios(Report report) {
        List<Tag> reportTags = report.getTags();
        String featureName = report.getName();
        String featureUri = report.getUri();
        int featureIndex = report.getFeatureIndex();
        for (Element element : report.getElements()) {
            element.setFeatureUri(report.getUri());
            element.setFeatureName(featureName);
            element.setFeatureIndex(featureIndex);
            if (reportTags.size() <= 0) continue;
            List<Tag> mergedTags = Stream.concat(element.getTags().stream(), reportTags.stream()).distinct().collect(Collectors.toList());
            element.setTags(mergedTags);
        }
    }

    private void mergeBackgroundScenarios(Report report) {
        ArrayList<Element> cleanedUpElements = new ArrayList<Element>();
        Element currentBackgroundElement = null;
        for (Element element : report.getElements()) {
            if (element.getType().equalsIgnoreCase("background")) {
                currentBackgroundElement = element;
                continue;
            }
            if (currentBackgroundElement != null) {
                element.getSteps().addAll(0, currentBackgroundElement.getSteps());
            }
            cleanedUpElements.add(element);
        }
        report.setElements(cleanedUpElements);
    }

    private void addFeatureIndex(Report report) {
        if (report == null) {
            return;
        }
        String featureName = report.getName();
        if (!this.featureUris.contains(featureName)) {
            this.featureUris.add(featureName);
        }
        report.setFeatureIndex(this.featureUris.indexOf(featureName));
    }

    public void postSerialize(JsonElement jsonElement, Report report, Gson gson) {
    }
}

