/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.json;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.trivago.cluecumber.constants.MimeType;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.json.processors.ElementJsonPostProcessor;
import com.trivago.cluecumber.json.processors.ReportJsonPostProcessor;
import io.gsonfire.GsonFireBuilder;
import io.gsonfire.PostProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class JsonPojoConverter {
    private final Gson gsonParserWithProcessors;

    @Inject
    public JsonPojoConverter(ReportJsonPostProcessor reportJsonPostProcessor, ElementJsonPostProcessor elementJsonPostProcessor) {
        GsonFireBuilder builder = new GsonFireBuilder().registerPostProcessor(Report.class, (PostProcessor)reportJsonPostProcessor).registerPostProcessor(Element.class, (PostProcessor)elementJsonPostProcessor).enumDefaultValue(MimeType.class, (Enum)MimeType.UNKNOWN);
        this.gsonParserWithProcessors = builder.createGson();
    }

    public List<Report> readJsonStream(InputStream in) throws CluecumberPluginException, IOException {
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        ArrayList<Report> reports = new ArrayList<Report>();
        reader.beginArray();
        while (reader.hasNext()) {
            Report report = (Report)this.gsonParserWithProcessors.fromJson(reader, Report.class);
            reports.add(report);
        }
        reader.endArray();
        reader.close();
        return reports;
    }

    public Report[] convertJsonToReportPojos(String json) throws CluecumberPluginException {
        Report[] reports;
        try {
            reports = (Report[])this.gsonParserWithProcessors.fromJson(json, Report[].class);
        }
        catch (JsonParseException e) {
            throw new CluecumberPluginException(e.getMessage());
        }
        return reports;
    }
}

