/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.json.processors;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.trivago.cluecumber.exceptions.filesystem.FileCreationException;
import com.trivago.cluecumber.filesystem.FileIO;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Embedding;
import com.trivago.cluecumber.json.pojo.ResultMatch;
import com.trivago.cluecumber.logging.CluecumberLogger;
import com.trivago.cluecumber.properties.PropertyManager;
import io.gsonfire.PostProcessor;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.codehaus.plexus.util.Base64;

@Singleton
public class ElementJsonPostProcessor
implements PostProcessor<Element> {
    private final PropertyManager propertyManager;
    private final FileIO fileIO;
    private final CluecumberLogger logger;
    private int attachmentIndex = 1;

    @Inject
    public ElementJsonPostProcessor(PropertyManager propertyManager, FileIO fileIO, CluecumberLogger logger) {
        this.propertyManager = propertyManager;
        this.fileIO = fileIO;
        this.logger = logger;
    }

    public void postDeserialize(Element element, JsonElement jsonElement, Gson gson) {
        element.setFailOnPendingOrUndefined(this.propertyManager.isFailScenariosOnPendingOrUndefinedSteps());
        this.processAttachments(element);
    }

    private void processAttachments(Element element) {
        element.getSteps().forEach(step -> {
            step.getBefore().stream().map(ResultMatch::getEmbeddings).forEach(this::processEmbedding);
            this.processEmbedding(step.getEmbeddings());
            step.getAfter().stream().map(ResultMatch::getEmbeddings).forEach(this::processEmbedding);
        });
        element.getBefore().stream().map(ResultMatch::getEmbeddings).forEach(this::processEmbedding);
        element.getAfter().stream().map(ResultMatch::getEmbeddings).forEach(this::processEmbedding);
    }

    private void processEmbedding(List<Embedding> embeddings) {
        embeddings.forEach(embedding -> {
            String filename = this.saveEmbeddingToFileAndGetFilename((Embedding)embedding);
            embedding.setFilename(filename);
            ++this.attachmentIndex;
        });
    }

    private String saveEmbeddingToFileAndGetFilename(Embedding embedding) {
        String fileEnding = "." + embedding.getFileEnding();
        byte[] dataBytes = Base64.decodeBase64((byte[])embedding.getData().getBytes(StandardCharsets.UTF_8));
        String filename = String.format("attachment%03d%s", this.attachmentIndex, fileEnding);
        try {
            this.fileIO.writeContentToFile(dataBytes, this.propertyManager.getGeneratedHtmlReportDirectory() + "/attachments/" + filename);
        }
        catch (FileCreationException e) {
            this.logger.warn("Could not process file  " + filename + " but will continue report generation...");
        }
        embedding.decodeData(embedding.getData());
        embedding.setData("");
        return filename;
    }

    public void postSerialize(JsonElement jsonElement, Element element, Gson gson) {
    }
}

