/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.logging;

import java.util.Arrays;
import javax.inject.Singleton;
import org.apache.maven.plugin.logging.Log;

@Singleton
public class CluecumberLogger {
    private Log mojoLogger;
    private CluecumberLogLevel currentLogLevel;

    public void initialize(Log mojoLogger, String currentLogLevel) {
        this.mojoLogger = mojoLogger;
        if (currentLogLevel == null) {
            this.currentLogLevel = CluecumberLogLevel.DEFAULT;
            return;
        }
        try {
            this.currentLogLevel = CluecumberLogLevel.valueOf(currentLogLevel.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.currentLogLevel = CluecumberLogLevel.DEFAULT;
            this.warn("Log level " + currentLogLevel + " is unknown. Cluecumber will use 'default' logging.");
        }
    }

    public void logInfoSeparator(CluecumberLogLevel ... cluecumberLogLevels) {
        this.info("------------------------------------------------------------------------", cluecumberLogLevels);
    }

    public void info(CharSequence logString, CluecumberLogLevel ... cluecumberLogLevels) {
        this.log(LogLevel.INFO, logString, cluecumberLogLevels);
    }

    public void warn(CharSequence logString) {
        CluecumberLogLevel[] logLevels = new CluecumberLogLevel[]{CluecumberLogLevel.DEFAULT, CluecumberLogLevel.COMPACT, CluecumberLogLevel.MINIMAL};
        this.log(LogLevel.WARN, logString, logLevels);
    }

    private void log(LogLevel logLevel, CharSequence logString, CluecumberLogLevel ... CluecumberLogLevels) {
        if (this.currentLogLevel == CluecumberLogLevel.OFF) {
            return;
        }
        if (this.currentLogLevel != null && CluecumberLogLevels != null && CluecumberLogLevels.length > 0 && Arrays.stream(CluecumberLogLevels).noneMatch(CluecumberLogLevel2 -> CluecumberLogLevel2 == this.currentLogLevel)) {
            return;
        }
        switch (logLevel) {
            case INFO: {
                this.mojoLogger.info(logString);
                break;
            }
            case WARN: {
                this.mojoLogger.warn(logString);
            }
        }
    }

    public static enum CluecumberLogLevel {
        DEFAULT,
        COMPACT,
        MINIMAL,
        OFF;

    }

    private static enum LogLevel {
        INFO,
        WARN;

    }
}

