/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderering;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.properties.PropertyManager;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CustomCssRenderer {
    private final PropertyManager propertyManager;

    @Inject
    public CustomCssRenderer(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public String getRenderedCustomCssContent(Template template) throws CluecumberPluginException {
        StringWriter stringWriter = new StringWriter();
        CustomStatusColors customStatusColors = new CustomStatusColors(this.propertyManager.getCustomStatusColorPassed(), this.propertyManager.getCustomStatusColorFailed(), this.propertyManager.getCustomStatusColorSkipped());
        try {
            template.process((Object)customStatusColors, (Writer)stringWriter);
        }
        catch (TemplateException | IOException e) {
            throw new CluecumberPluginException("Could not render custom css content: " + e.getMessage());
        }
        return ((Object)stringWriter).toString();
    }

    public static class CustomStatusColors {
        private final String passedColor;
        private final String failedColor;
        private final String skippedColor;

        CustomStatusColors(String passedColor, String failedColor, String skippedColor) {
            this.passedColor = passedColor;
            this.failedColor = failedColor;
            this.skippedColor = skippedColor;
        }

        public String getPassedColor() {
            return this.passedColor;
        }

        public String getFailedColor() {
            return this.failedColor;
        }

        public String getSkippedColor() {
            return this.skippedColor;
        }
    }
}

