/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.properties;

import com.trivago.cluecumber.constants.PluginSettings;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.exceptions.filesystem.MissingFileException;
import com.trivago.cluecumber.exceptions.properties.WrongOrMissingPropertyException;
import com.trivago.cluecumber.filesystem.FileIO;
import com.trivago.cluecumber.logging.CluecumberLogger;
import com.trivago.cluecumber.properties.PropertiesFileLoader;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PropertyManager {
    private static final String COLOR_PATTERN = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
    private final CluecumberLogger logger;
    private final FileIO fileIO;
    private final PropertiesFileLoader propertiesFileLoader;
    private String sourceJsonReportDirectory;
    private String generatedHtmlReportDirectory;
    private boolean failScenariosOnPendingOrUndefinedSteps;
    private boolean expandBeforeAfterHooks;
    private boolean expandStepHooks;
    private boolean expandDocStrings;
    private final Map<String, String> customParameters = new LinkedHashMap<String, String>();
    private String customCssFile;
    private String customParametersFile;
    private String customStatusColorPassed = "#28a745";
    private String customStatusColorFailed = "#dc3545";
    private String customStatusColorSkipped = "#ffc107";
    private String customPageTitle = "Cluecumber Report";
    private PluginSettings.StartPage startPage;

    @Inject
    public PropertyManager(CluecumberLogger logger, FileIO fileIO, PropertiesFileLoader propertiesFileLoader) {
        this.logger = logger;
        this.fileIO = fileIO;
        this.propertiesFileLoader = propertiesFileLoader;
    }

    public String getSourceJsonReportDirectory() {
        return this.sourceJsonReportDirectory;
    }

    public void setSourceJsonReportDirectory(String sourceJsonReportDirectory) throws WrongOrMissingPropertyException {
        if (!this.isSet(sourceJsonReportDirectory)) {
            throw new WrongOrMissingPropertyException("sourceJsonReportDirectory");
        }
        this.sourceJsonReportDirectory = sourceJsonReportDirectory;
    }

    public String getGeneratedHtmlReportDirectory() {
        return this.generatedHtmlReportDirectory;
    }

    public void setGeneratedHtmlReportDirectory(String generatedHtmlReportDirectory) throws WrongOrMissingPropertyException {
        if (!this.isSet(generatedHtmlReportDirectory)) {
            throw new WrongOrMissingPropertyException("generatedHtmlReportDirectory");
        }
        this.generatedHtmlReportDirectory = generatedHtmlReportDirectory;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public void setCustomParameters(Map<String, String> customParameters) {
        this.customParameters.putAll(customParameters);
    }

    String getCustomParametersFile() {
        return this.customParametersFile;
    }

    public void setCustomParametersFile(String customParametersFile) throws CluecumberPluginException {
        this.customParametersFile = customParametersFile;
        if (!this.isSet(customParametersFile)) {
            return;
        }
        if (!this.fileIO.isExistingFile(customParametersFile)) {
            throw new MissingFileException(customParametersFile + " (customParametersFile)");
        }
        LinkedHashMap<String, String> customParameters = this.propertiesFileLoader.loadPropertiesMap(customParametersFile);
        this.customParameters.putAll(customParameters);
    }

    public boolean isFailScenariosOnPendingOrUndefinedSteps() {
        return this.failScenariosOnPendingOrUndefinedSteps;
    }

    public void setFailScenariosOnPendingOrUndefinedSteps(boolean failScenariosOnPendingOrUndefinedSteps) {
        this.failScenariosOnPendingOrUndefinedSteps = failScenariosOnPendingOrUndefinedSteps;
    }

    public boolean isExpandBeforeAfterHooks() {
        return this.expandBeforeAfterHooks;
    }

    public void setExpandBeforeAfterHooks(boolean expandBeforeAfterHooks) {
        this.expandBeforeAfterHooks = expandBeforeAfterHooks;
    }

    public boolean isExpandStepHooks() {
        return this.expandStepHooks;
    }

    public void setExpandStepHooks(boolean expandStepHooks) {
        this.expandStepHooks = expandStepHooks;
    }

    public boolean isExpandDocStrings() {
        return this.expandDocStrings;
    }

    public void setExpandDocStrings(boolean expandDocStrings) {
        this.expandDocStrings = expandDocStrings;
    }

    public String getCustomCssFile() {
        return this.customCssFile;
    }

    public void setCustomCssFile(String customCssFile) throws MissingFileException {
        this.customCssFile = customCssFile;
        if (!this.isSet(customCssFile)) {
            return;
        }
        if (!this.fileIO.isExistingFile(customCssFile)) {
            throw new MissingFileException(customCssFile + " (customCssFile)");
        }
    }

    public String getCustomStatusColorPassed() {
        return this.customStatusColorPassed;
    }

    public void setCustomStatusColorPassed(String customStatusColorPassed) throws WrongOrMissingPropertyException {
        if (!this.isSet(customStatusColorPassed)) {
            return;
        }
        this.checkHexColorValidity(customStatusColorPassed, "customStatusColorPassed");
        this.customStatusColorPassed = customStatusColorPassed;
    }

    public String getCustomStatusColorFailed() {
        return this.customStatusColorFailed;
    }

    public void setCustomStatusColorFailed(String customStatusColorFailed) throws WrongOrMissingPropertyException {
        if (!this.isSet(customStatusColorFailed)) {
            return;
        }
        this.checkHexColorValidity(customStatusColorFailed, "customStatusColorFailed");
        this.customStatusColorFailed = customStatusColorFailed;
    }

    public String getCustomStatusColorSkipped() {
        return this.customStatusColorSkipped;
    }

    public void setCustomStatusColorSkipped(String customStatusColorSkipped) throws WrongOrMissingPropertyException {
        if (!this.isSet(customStatusColorSkipped)) {
            return;
        }
        this.checkHexColorValidity(customStatusColorSkipped, "customStatusColorSkipped");
        this.customStatusColorSkipped = customStatusColorSkipped;
    }

    public String getCustomPageTitle() {
        return this.customPageTitle;
    }

    public void setCustomPageTitle(String customPageTitle) {
        if (this.isSet(customPageTitle)) {
            this.customPageTitle = customPageTitle;
        }
    }

    public void logProperties() {
        this.logger.info("- source JSON report directory     : " + this.sourceJsonReportDirectory, CluecumberLogger.CluecumberLogLevel.DEFAULT, CluecumberLogger.CluecumberLogLevel.COMPACT);
        this.logger.info("- generated HTML report directory  : " + this.generatedHtmlReportDirectory, CluecumberLogger.CluecumberLogLevel.DEFAULT, CluecumberLogger.CluecumberLogLevel.COMPACT);
        boolean customParametersFileExists = this.isSet(this.customParametersFile);
        if (customParametersFileExists) {
            this.logger.logInfoSeparator(CluecumberLogger.CluecumberLogLevel.DEFAULT);
            this.logger.info("- custom parameters file           : " + this.customParametersFile, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        }
        if (!this.customParameters.isEmpty()) {
            if (!customParametersFileExists) {
                this.logger.logInfoSeparator(new CluecumberLogger.CluecumberLogLevel[0]);
            }
            this.customParameters.entrySet().stream().map(entry -> "- custom parameter                 : " + (String)entry.getKey() + " -> " + (String)entry.getValue()).forEach(logString -> this.logger.info((CharSequence)logString, CluecumberLogger.CluecumberLogLevel.DEFAULT));
        }
        this.logger.logInfoSeparator(CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- fail pending/undefined scenarios : " + this.failScenariosOnPendingOrUndefinedSteps, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- expand before/after hooks        : " + this.expandBeforeAfterHooks, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- expand step hooks                : " + this.expandStepHooks, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- expand doc strings               : " + this.expandDocStrings, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- page title                       : " + this.customPageTitle, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- start page                       : " + (Object)((Object)this.startPage), CluecumberLogger.CluecumberLogLevel.DEFAULT);
        if (this.isSet(this.customCssFile)) {
            this.logger.info("- custom CSS file                  : " + this.customCssFile, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        }
        this.logger.info("- colors (passed, failed, skipped) : " + this.customStatusColorPassed + ", " + this.customStatusColorFailed + ", " + this.customStatusColorSkipped, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.logInfoSeparator(CluecumberLogger.CluecumberLogLevel.DEFAULT);
    }

    private boolean isSet(String string) {
        return string != null && !string.trim().isEmpty();
    }

    private void checkHexColorValidity(String color, String colorPropertyName) throws WrongOrMissingPropertyException {
        if (!Pattern.compile(COLOR_PATTERN).matcher(color).matches()) {
            throw new WrongOrMissingPropertyException(colorPropertyName);
        }
    }

    public PluginSettings.StartPage getStartPage() {
        return this.startPage;
    }

    public void setStartPage(String startPage) {
        try {
            this.startPage = PluginSettings.StartPage.valueOf(startPage.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Unknown start page '" + startPage + "'. Must be one of " + Arrays.toString((Object[])PluginSettings.StartPage.values()));
            this.startPage = PluginSettings.StartPage.ALL_SCENARIOS;
        }
    }
}

