/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderering;

import com.trivago.cluecumber.constants.ChartConfiguration;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.rendering.pages.charts.StackedBarChartBuilder;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.rendering.pages.pojos.Feature;
import com.trivago.cluecumber.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllFeaturesPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.PageWithChartRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AllFeaturesPageRenderer
extends PageWithChartRenderer {
    private final ChartConfiguration chartConfiguration;

    @Inject
    public AllFeaturesPageRenderer(ChartJsonConverter chartJsonConverter, ChartConfiguration chartConfiguration) {
        super(chartJsonConverter);
        this.chartConfiguration = chartConfiguration;
    }

    public String getRenderedContent(AllFeaturesPageCollection allFeaturesPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(allFeaturesPageCollection);
        return this.processedContent(template, allFeaturesPageCollection);
    }

    private void addChartJsonToReportDetails(AllFeaturesPageCollection allFeaturesPageCollection) {
        ArrayList<Integer> passed = new ArrayList<Integer>();
        ArrayList<Integer> failed = new ArrayList<Integer>();
        ArrayList<Integer> skipped = new ArrayList<Integer>();
        int maximumNumberOfRuns = 0;
        for (Map.Entry<Feature, ResultCount> entry : allFeaturesPageCollection.getFeatureResultCounts().entrySet()) {
            ResultCount value = entry.getValue();
            passed.add(value.getPassed());
            failed.add(value.getFailed());
            skipped.add(value.getSkipped());
            if (value.getTotal() <= maximumNumberOfRuns) continue;
            maximumNumberOfRuns = value.getTotal();
        }
        List<String> keys = allFeaturesPageCollection.getFeatureResultCounts().keySet().stream().map(Feature::getName).collect(Collectors.toList());
        Chart chart = new StackedBarChartBuilder(this.chartConfiguration).setLabels(keys).setxAxisLabel(allFeaturesPageCollection.getTotalNumberOfFeatures() + " Features").setyAxisLabel("Number of Scenarios").setyAxisStepSize(maximumNumberOfRuns).addValues(passed, Status.PASSED).addValues(failed, Status.FAILED).addValues(skipped, Status.SKIPPED).build();
        allFeaturesPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }
}

