/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderering;

import com.trivago.cluecumber.constants.ChartConfiguration;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.json.pojo.Step;
import com.trivago.cluecumber.json.pojo.Tag;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.rendering.pages.charts.PieChartBuilder;
import com.trivago.cluecumber.rendering.pages.pojos.CustomParameter;
import com.trivago.cluecumber.rendering.pages.pojos.Feature;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.PageWithChartRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AllScenariosPageRenderer
extends PageWithChartRenderer {
    private final PropertyManager propertyManager;
    private final ChartConfiguration chartConfiguration;

    @Inject
    AllScenariosPageRenderer(ChartJsonConverter chartJsonConverter, ChartConfiguration chartConfiguration, PropertyManager propertyManager) {
        super(chartJsonConverter);
        this.propertyManager = propertyManager;
        this.chartConfiguration = chartConfiguration;
    }

    public String getRenderedContent(AllScenariosPageCollection allScenariosPageCollection, Template template) throws CluecumberPluginException {
        AllScenariosPageCollection allScenariosPageCollectionClone = this.getAllScenariosPageCollectionClone(allScenariosPageCollection);
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        this.addCustomParametersToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone);
    }

    public String getRenderedContentByTagFilter(AllScenariosPageCollection allScenariosPageCollection, Template template, Tag tag) throws CluecumberPluginException {
        AllScenariosPageCollection allScenariosPageCollectionClone = this.getAllScenariosPageCollectionClone(allScenariosPageCollection);
        allScenariosPageCollectionClone.setTagFilter(tag);
        allScenariosPageCollectionClone.getReports().forEach(report -> {
            List<Element> elements = report.getElements().stream().filter(element -> element.getTags().contains(tag)).collect(Collectors.toList());
            report.setElements(elements);
        });
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone);
    }

    public String getRenderedContentByStepFilter(AllScenariosPageCollection allScenariosPageCollection, Template template, Step step) throws CluecumberPluginException {
        AllScenariosPageCollection allScenariosPageCollectionClone = this.getAllScenariosPageCollectionClone(allScenariosPageCollection);
        allScenariosPageCollectionClone.setStepFilter(step);
        allScenariosPageCollectionClone.getReports().forEach(report -> {
            List<Element> elements = report.getElements().stream().filter(element -> element.getSteps().contains(step)).collect(Collectors.toList());
            report.setElements(elements);
        });
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone);
    }

    public String getRenderedContentByFeatureFilter(AllScenariosPageCollection allScenariosPageCollection, Template template, Feature feature) throws CluecumberPluginException {
        AllScenariosPageCollection allScenariosPageCollectionClone = this.getAllScenariosPageCollectionClone(allScenariosPageCollection);
        allScenariosPageCollectionClone.setFeatureFilter(feature);
        Report[] reportArray = (Report[])allScenariosPageCollectionClone.getReports().stream().filter(report -> report.getFeatureIndex() == feature.getIndex()).toArray(Report[]::new);
        allScenariosPageCollectionClone.clearReports();
        allScenariosPageCollectionClone.addReports(reportArray);
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone);
    }

    private void addChartJsonToReportDetails(AllScenariosPageCollection allScenariosPageCollection) {
        allScenariosPageCollection.getReportDetails().setChartJson(this.convertChartToJson(new PieChartBuilder(this.chartConfiguration).addValue(allScenariosPageCollection.getTotalNumberOfPassedScenarios(), Status.PASSED).addValue(allScenariosPageCollection.getTotalNumberOfFailedScenarios(), Status.FAILED).addValue(allScenariosPageCollection.getTotalNumberOfSkippedScenarios(), Status.SKIPPED).build()));
    }

    private void addCustomParametersToReportDetails(AllScenariosPageCollection allScenariosPageCollection) {
        Map<String, String> customParameterMap = this.propertyManager.getCustomParameters();
        if (customParameterMap == null || customParameterMap.isEmpty()) {
            return;
        }
        ArrayList<CustomParameter> customParameters = new ArrayList<CustomParameter>();
        customParameterMap.forEach((key1, value) -> {
            if (value == null || value.trim().isEmpty()) {
                return;
            }
            String key = key1.replace("_", " ");
            CustomParameter customParameter = new CustomParameter(key, (String)value);
            customParameters.add(customParameter);
        });
        allScenariosPageCollection.setCustomParameters(customParameters);
    }

    private AllScenariosPageCollection getAllScenariosPageCollectionClone(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberPluginException {
        AllScenariosPageCollection clone;
        try {
            clone = (AllScenariosPageCollection)allScenariosPageCollection.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CluecumberPluginException("Clone of AllScenariosPageCollection not supported: " + e.getMessage());
        }
        return clone;
    }
}

