/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.templates;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.rendering.pages.templates.TemplateConfiguration;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TemplateEngine {
    private final TemplateConfiguration templateConfiguration;

    @Inject
    TemplateEngine(TemplateConfiguration templateConfiguration) {
        this.templateConfiguration = templateConfiguration;
        templateConfiguration.init("/template");
    }

    public freemarker.template.Template getTemplate(Template template) throws CluecumberPluginException {
        return this.templateConfiguration.getTemplate(template.fileName);
    }

    public static enum Template {
        ALL_FEATURES("feature-summary"),
        ALL_SCENARIOS("scenario-summary"),
        SCENARIO_SEQUENCE("scenario-sequence"),
        ALL_STEPS("step-summary"),
        ALL_TAGS("tag-summary"),
        SCENARIO_DETAILS("scenario-detail"),
        CUSTOM_CSS("custom-css"),
        START_PAGE("index");

        private final String fileName;

        private Template(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

