/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderering;

import com.trivago.cluecumber.constants.ChartConfiguration;
import com.trivago.cluecumber.constants.PluginSettings;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.json.pojo.Step;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.rendering.pages.charts.StackedBarChartBuilder;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllStepsPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.PageWithChartRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class AllStepsPageRenderer
extends PageWithChartRenderer {
    private final ChartConfiguration chartConfiguration;
    private final PropertyManager propertyManager;

    @Inject
    public AllStepsPageRenderer(ChartJsonConverter chartJsonConverter, ChartConfiguration chartConfiguration, PropertyManager propertyManager) {
        super(chartJsonConverter);
        this.chartConfiguration = chartConfiguration;
        this.propertyManager = propertyManager;
    }

    public String getRenderedContent(AllStepsPageCollection allStepsPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(allStepsPageCollection);
        if (this.propertyManager.getCustomParametersDisplayMode() == PluginSettings.CustomParamDisplayMode.ALL_PAGES) {
            this.addCustomParametersToReportDetails(allStepsPageCollection, this.propertyManager.getCustomParameters());
        }
        return this.processedContent(template, allStepsPageCollection);
    }

    private void addChartJsonToReportDetails(AllStepsPageCollection allTagsPageCollection) {
        ArrayList<Integer> passed = new ArrayList<Integer>();
        ArrayList<Integer> failed = new ArrayList<Integer>();
        ArrayList<Integer> skipped = new ArrayList<Integer>();
        int maximumNumberOfRuns = 0;
        for (Map.Entry<Step, ResultCount> entry : allTagsPageCollection.getStepResultCounts().entrySet()) {
            ResultCount value = entry.getValue();
            passed.add(value.getPassed());
            failed.add(value.getFailed());
            skipped.add(value.getSkipped());
            if (value.getTotal() <= maximumNumberOfRuns) continue;
            maximumNumberOfRuns = value.getTotal();
        }
        List<String> keys = allTagsPageCollection.getStepResultCounts().keySet().stream().map(Step::returnNameWithArgumentPlaceholders).collect(Collectors.toList());
        Chart chart = new StackedBarChartBuilder(this.chartConfiguration).setLabels(keys).setxAxisLabel(allTagsPageCollection.getTotalNumberOfSteps() + " Steps").setyAxisStepSize(maximumNumberOfRuns).setyAxisLabel("Number of Usages").addValues(passed, Status.PASSED).addValues(failed, Status.FAILED).addValues(skipped, Status.SKIPPED).build();
        allTagsPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }
}

