/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.charts;

import com.trivago.cluecumber.constants.ChartConfiguration;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Axis;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Data;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Dataset;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Options;
import com.trivago.cluecumber.rendering.pages.charts.pojos.ScaleLabel;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Scales;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Ticks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StackedBarChartBuilder {
    private final ChartConfiguration chartConfiguration;
    private List<String> labels;
    private final List<Dataset> datasets = new ArrayList<Dataset>();
    private String xAxisLabel;
    private String yAxisLabel;
    private float yAxisStepSize = 1.0f;
    private boolean stacked = true;

    public StackedBarChartBuilder(ChartConfiguration chartConfiguration) {
        this.chartConfiguration = chartConfiguration;
    }

    public StackedBarChartBuilder addValues(List<Float> values, Status status) {
        String color = this.chartConfiguration.getColorRgbaStringByStatus(status);
        Dataset dataset = new Dataset();
        dataset.setLabel(status.getStatusString());
        dataset.setData(values);
        ArrayList<String> colors = new ArrayList<String>(Collections.nCopies(values.size(), color));
        dataset.setBackgroundColor(colors);
        this.datasets.add(dataset);
        return this;
    }

    public StackedBarChartBuilder setLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public StackedBarChartBuilder setxAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        return this;
    }

    public StackedBarChartBuilder setyAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        return this;
    }

    public StackedBarChartBuilder setyAxisStepSize(float yAxisStepSize) {
        this.yAxisStepSize = yAxisStepSize;
        return this;
    }

    public StackedBarChartBuilder setStacked(boolean stacked) {
        this.stacked = stacked;
        return this;
    }

    public Chart build() {
        Chart chart = new Chart();
        chart.setType(ChartConfiguration.Type.bar);
        Data data = new Data();
        data.setLabels(this.labels);
        for (Dataset dataset : this.datasets) {
            if (this.stacked) continue;
            dataset.setStack("complete");
        }
        data.setDatasets(this.datasets);
        chart.setData(data);
        Options options = new Options();
        Scales scales = new Scales();
        ArrayList<Axis> xAxes = new ArrayList<Axis>();
        Axis xAxis = new Axis();
        xAxis.setStacked(true);
        Ticks xTicks = new Ticks();
        xTicks.setDisplay(false);
        xAxis.setTicks(xTicks);
        ScaleLabel xScaleLabel = new ScaleLabel();
        xScaleLabel.setDisplay(true);
        xScaleLabel.setLabelString(this.xAxisLabel);
        xAxis.setScaleLabel(xScaleLabel);
        xAxes.add(xAxis);
        scales.setxAxes(xAxes);
        ArrayList<Axis> yAxes = new ArrayList<Axis>();
        Axis yAxis = new Axis();
        yAxis.setStacked(true);
        Ticks yTicks = new Ticks();
        yTicks.setStepSize(this.yAxisStepSize);
        yAxis.setTicks(yTicks);
        ScaleLabel yScaleLabel = new ScaleLabel();
        yScaleLabel.setDisplay(true);
        yScaleLabel.setLabelString(this.yAxisLabel);
        yAxis.setScaleLabel(yScaleLabel);
        yAxes.add(yAxis);
        scales.setyAxes(yAxes);
        options.setScales(scales);
        ArrayList<String> events = new ArrayList<String>();
        events.add("click");
        events.add("mousemove");
        options.setEvents(events);
        chart.setOptions(options);
        return chart;
    }
}

