/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderering;

import com.trivago.cluecumber.constants.ChartConfiguration;
import com.trivago.cluecumber.constants.PluginSettings;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.rendering.pages.charts.StackedBarChartBuilder;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.rendering.pages.pojos.Feature;
import com.trivago.cluecumber.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllFeaturesPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.PageWithChartRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AllFeaturesPageRenderer
extends PageWithChartRenderer {
    private final ChartConfiguration chartConfiguration;
    private final PropertyManager propertyManager;

    @Inject
    public AllFeaturesPageRenderer(ChartJsonConverter chartJsonConverter, ChartConfiguration chartConfiguration, PropertyManager propertyManager) {
        super(chartJsonConverter);
        this.chartConfiguration = chartConfiguration;
        this.propertyManager = propertyManager;
    }

    public String getRenderedContent(AllFeaturesPageCollection allFeaturesPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(allFeaturesPageCollection);
        if (this.propertyManager.getCustomParametersDisplayMode() == PluginSettings.CustomParamDisplayMode.ALL_PAGES) {
            this.addCustomParametersToReportDetails(allFeaturesPageCollection, this.propertyManager.getCustomParameters());
        }
        return this.processedContent(template, allFeaturesPageCollection, this.propertyManager.getNavigationLinks());
    }

    private void addChartJsonToReportDetails(AllFeaturesPageCollection allFeaturesPageCollection) {
        ArrayList<Float> passed = new ArrayList<Float>();
        ArrayList<Float> failed = new ArrayList<Float>();
        ArrayList<Float> skipped = new ArrayList<Float>();
        int maximumNumberOfRuns = 0;
        for (Map.Entry<Feature, ResultCount> entry : allFeaturesPageCollection.getFeatureResultCounts().entrySet()) {
            ResultCount value = entry.getValue();
            passed.add(Float.valueOf(value.getPassed()));
            failed.add(Float.valueOf(value.getFailed()));
            skipped.add(Float.valueOf(value.getSkipped()));
            if (value.getTotal() <= maximumNumberOfRuns) continue;
            maximumNumberOfRuns = value.getTotal();
        }
        List<String> keys = allFeaturesPageCollection.getFeatureResultCounts().keySet().stream().map(Feature::getName).collect(Collectors.toList());
        Chart chart = new StackedBarChartBuilder(this.chartConfiguration).setLabels(keys).setxAxisLabel(allFeaturesPageCollection.getTotalNumberOfFeatures() + " Features").setyAxisLabel("Number of Scenarios").setyAxisStepSize(maximumNumberOfRuns).addValues(passed, Status.PASSED).addValues(failed, Status.FAILED).addValues(skipped, Status.SKIPPED).build();
        allFeaturesPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }
}

