/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderering;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.rendering.pages.pojos.CustomParameter;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.Link;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.PageCollection;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PageRenderer {
    String processedContent(Template template, Object pageCollection, List<Link> navigation) throws CluecumberPluginException {
        if (pageCollection instanceof PageCollection) {
            ((PageCollection)pageCollection).setNavigationLinks(navigation);
        }
        StringWriter stringWriter = new StringWriter();
        try {
            template.process(pageCollection, (Writer)stringWriter);
        }
        catch (TemplateException | IOException e) {
            throw new CluecumberPluginException("Could not render page content: " + e.getMessage());
        }
        return ((Object)stringWriter).toString();
    }

    protected void addCustomParametersToReportDetails(PageCollection pageCollection, Map<String, String> customParameterMap) {
        if (customParameterMap == null || customParameterMap.isEmpty()) {
            return;
        }
        ArrayList<CustomParameter> customParameters = new ArrayList<CustomParameter>();
        customParameterMap.forEach((key, value) -> {
            if (value != null && !value.trim().isEmpty()) {
                String newKey = key.replace("_", " ");
                CustomParameter customParameter = new CustomParameter(newKey, (String)value);
                customParameters.add(customParameter);
            }
        });
        pageCollection.setCustomParameters(customParameters);
    }
}

