/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderering;

import com.trivago.cluecumber.constants.ChartConfiguration;
import com.trivago.cluecumber.constants.PluginSettings;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.ResultMatch;
import com.trivago.cluecumber.json.pojo.Step;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.rendering.pages.charts.StackedBarChartBuilder;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.ScenarioDetailsPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.PageWithChartRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScenarioDetailsPageRenderer
extends PageWithChartRenderer {
    private final ChartConfiguration chartConfiguration;
    private final PropertyManager propertyManager;

    @Inject
    public ScenarioDetailsPageRenderer(ChartJsonConverter chartJsonConverter, ChartConfiguration chartConfiguration, PropertyManager propertyManager) {
        super(chartJsonConverter);
        this.chartConfiguration = chartConfiguration;
        this.propertyManager = propertyManager;
    }

    public String getRenderedContent(ScenarioDetailsPageCollection scenarioDetailsPageCollection, Template template) throws CluecumberPluginException {
        scenarioDetailsPageCollection.setExpandBeforeAfterHooks(this.propertyManager.isExpandBeforeAfterHooks());
        scenarioDetailsPageCollection.setExpandStepHooks(this.propertyManager.isExpandStepHooks());
        scenarioDetailsPageCollection.setExpandDocStrings(this.propertyManager.isExpandDocStrings());
        scenarioDetailsPageCollection.setExpandAttachments(this.propertyManager.isExpandAttachments());
        this.addChartJsonToReportDetails(scenarioDetailsPageCollection);
        if (this.propertyManager.getCustomParametersDisplayMode() == PluginSettings.CustomParamDisplayMode.ALL_PAGES) {
            this.addCustomParametersToReportDetails(scenarioDetailsPageCollection, this.propertyManager.getCustomParameters());
        }
        return this.processedContent(template, scenarioDetailsPageCollection, this.propertyManager.getNavigationLinks());
    }

    private void addChartJsonToReportDetails(ScenarioDetailsPageCollection scenarioDetailsPageCollection) {
        Element element = scenarioDetailsPageCollection.getElement();
        ArrayList<String> labels = new ArrayList<String>();
        element.getBefore().stream().map(ResultMatch::getGlueMethodName).forEach(labels::add);
        element.getSteps().stream().map(Step::getName).forEach(labels::add);
        element.getAfter().stream().map(ResultMatch::getGlueMethodName).forEach(labels::add);
        List<Float> passedValues = this.getValuesByStatus(element, Status.PASSED);
        List<Float> failedValues = this.getValuesByStatus(element, Status.FAILED);
        List<Float> skippedValues = this.getValuesByStatus(element, Status.SKIPPED);
        float passedMax = 0.0f;
        for (Float f : passedValues) {
            if (!(f.floatValue() > passedMax)) continue;
            passedMax = f.floatValue();
        }
        float skippedMax = 0.0f;
        for (Float f : skippedValues) {
            if (!(f.floatValue() > skippedMax)) continue;
            skippedMax = f.floatValue();
        }
        float f = 0.0f;
        for (Float failedValue : failedValues) {
            if (!(failedValue.floatValue() > f)) continue;
            f = failedValue.floatValue();
        }
        Float f2 = Collections.max(Arrays.asList(Float.valueOf(passedMax), Float.valueOf(f), Float.valueOf(skippedMax)));
        Chart chart = new StackedBarChartBuilder(this.chartConfiguration).setxAxisLabel("Steps").setyAxisLabel("Step Runtime (seconds)").setyAxisStepSize(f2.floatValue()).setLabels(labels).setStacked(false).addValues(passedValues, Status.PASSED).addValues(failedValues, Status.FAILED).addValues(skippedValues, Status.SKIPPED).build();
        scenarioDetailsPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }

    private List<Float> getValuesByStatus(Element element, Status status) {
        ArrayList<Float> values = new ArrayList<Float>();
        element.getAllResultMatches().forEach(resultMatch -> {
            if (resultMatch.getConsolidatedStatus() == status) {
                values.add(Float.valueOf((float)resultMatch.getResult().getDurationInMilliseconds() / 1000.0f));
            } else {
                values.add(Float.valueOf(0.0f));
            }
        });
        return values;
    }
}

