/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.json.pojo;

import com.google.gson.annotations.SerializedName;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.json.pojo.ResultMatch;
import com.trivago.cluecumber.json.pojo.Step;
import com.trivago.cluecumber.json.pojo.Tag;
import com.trivago.cluecumber.rendering.pages.renderering.RenderingUtils;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class Element {
    private List<ResultMatch> before = new ArrayList<ResultMatch>();
    private int line;
    private String featureName = "";
    private String featureUri = "";
    private String name = "";
    private String description = "";
    private String id = "";
    private List<ResultMatch> after = new ArrayList<ResultMatch>();
    private String type = "";
    private String keyword = "";
    private List<Step> backgroundSteps = new ArrayList<Step>();
    private List<Step> steps = new ArrayList<Step>();
    private List<Tag> tags = new ArrayList<Tag>();
    @SerializedName(value="start_timestamp")
    private String startTimestamp = "";
    private transient int featureIndex = 0;
    private transient int scenarioIndex = 0;
    private transient boolean failOnPendingOrUndefined = false;

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(String startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public ZonedDateTime getStartDateTime() {
        return RenderingUtils.convertTimestampToZonedDateTime(this.startTimestamp);
    }

    public ZonedDateTime getEndDateTime() {
        ZonedDateTime startDateTime = this.getStartDateTime();
        if (startDateTime != null) {
            return this.getStartDateTime().plusNanos(this.getTotalDuration());
        }
        return null;
    }

    public String getStartDateString() {
        return RenderingUtils.convertZonedDateTimeToDateString(this.getStartDateTime());
    }

    public String getStartTimeString() {
        return RenderingUtils.convertZonedDateTimeToTimeString(this.getStartDateTime());
    }

    public String getEndDateString() {
        return RenderingUtils.convertZonedDateTimeToDateString(this.getEndDateTime());
    }

    public String getEndTimeString() {
        return RenderingUtils.convertZonedDateTimeToTimeString(this.getEndDateTime());
    }

    public List<ResultMatch> getBefore() {
        return this.before;
    }

    public void setBefore(List<ResultMatch> before) {
        this.before = before;
    }

    public boolean anyBeforeHookHasContent() {
        for (ResultMatch resultMatch : this.before) {
            if (!resultMatch.hasContent() && !resultMatch.isFailed()) continue;
            return true;
        }
        return false;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getName() {
        return !this.name.isEmpty() ? this.name : "[Unnamed]";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<ResultMatch> getAfter() {
        return this.after;
    }

    public void setAfter(List<ResultMatch> after) {
        this.after = after;
    }

    public boolean anyAfterHookHasContent() {
        for (ResultMatch resultMatch : this.after) {
            if (!resultMatch.hasContent() && !resultMatch.isFailed()) continue;
            return true;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public List<Step> getBackgroundSteps() {
        return this.backgroundSteps;
    }

    public void setBackgroundSteps(List<Step> steps) {
        this.backgroundSteps = steps;
    }

    public boolean isScenario() {
        return this.type.equals("scenario");
    }

    public boolean isFailed() {
        return this.getStatus() == Status.FAILED;
    }

    public boolean isPassed() {
        return this.getStatus() == Status.PASSED;
    }

    public boolean isSkipped() {
        return this.getStatus() == Status.SKIPPED;
    }

    public Status getStatus() {
        int totalSteps = this.steps.size();
        if (totalSteps == 0) {
            return Status.SKIPPED;
        }
        for (ResultMatch beforeHook : this.before) {
            if (!beforeHook.isFailed()) continue;
            return Status.FAILED;
        }
        for (ResultMatch afterHook : this.after) {
            if (!afterHook.isFailed()) continue;
            return Status.FAILED;
        }
        for (Status status : Status.BASIC_STATES) {
            int stepsWithCertainStatusCount = 0;
            for (Step step : this.steps) {
                if (step.getConsolidatedStatus() == status) {
                    ++stepsWithCertainStatusCount;
                }
                for (ResultMatch beforeStepHook : step.getBefore()) {
                    if (!beforeStepHook.isFailed()) continue;
                    return Status.FAILED;
                }
                for (ResultMatch afterStepHook : step.getAfter()) {
                    if (!afterStepHook.isFailed()) continue;
                    return Status.FAILED;
                }
            }
            if (totalSteps != stepsWithCertainStatusCount) continue;
            if (status == Status.SKIPPED && this.failOnPendingOrUndefined) {
                return Status.FAILED;
            }
            return status;
        }
        if (this.getTotalNumberOfPassedSteps() >= 0 && this.getTotalNumberOfSkippedSteps() + this.getTotalNumberOfPassedSteps() == this.getTotalNumberOfSteps()) {
            if (this.failOnPendingOrUndefined) {
                return Status.FAILED;
            }
            return Status.PASSED;
        }
        if (this.getTotalNumberOfSkippedSteps() == totalSteps) {
            if (this.failOnPendingOrUndefined) {
                return Status.FAILED;
            }
            return Status.SKIPPED;
        }
        return Status.FAILED;
    }

    public String getFirstExceptionClass() {
        String firstException = this.getFirstException();
        String exceptionClass = firstException.split("\n")[0].trim();
        if (exceptionClass.isEmpty()) {
            exceptionClass = "unknown";
        }
        return exceptionClass;
    }

    public String getFirstException() {
        String exception = this.getResultListException(this.before);
        if (exception != null) {
            return exception;
        }
        exception = this.getStepException(this.backgroundSteps);
        if (exception != null) {
            return exception;
        }
        exception = this.getStepException(this.steps);
        if (exception != null) {
            return RenderingUtils.escapeHTML(exception);
        }
        exception = this.getResultListException(this.after);
        if (exception != null) {
            return exception;
        }
        return "";
    }

    private String getStepException(List<Step> steps) {
        for (Step step : steps) {
            String exception = this.getResultListException(step.getBefore());
            if (exception != null) {
                return exception;
            }
            if (step.isFailed()) {
                return step.getResult().getErrorMessage();
            }
            exception = this.getResultListException(step.getAfter());
            if (exception == null) continue;
            return exception;
        }
        return null;
    }

    private String getResultListException(List<ResultMatch> resultMatches) {
        for (ResultMatch match : resultMatches) {
            if (!match.isFailed()) continue;
            return RenderingUtils.escapeHTML(match.getResult().getErrorMessage());
        }
        return null;
    }

    public int getScenarioIndex() {
        return this.scenarioIndex;
    }

    public void setScenarioIndex(int scenarioIndex) {
        this.scenarioIndex = scenarioIndex;
    }

    public int getTotalNumberOfSteps() {
        return this.getSteps().size();
    }

    public int getTotalNumberOfPassedSteps() {
        return this.getNumberOfStepsWithStatus(Status.PASSED);
    }

    public int getTotalNumberOfFailedSteps() {
        return this.getNumberOfStepsWithStatus(Status.FAILED);
    }

    public int getTotalNumberOfSkippedSteps() {
        return this.getNumberOfStepsWithStatus(Status.SKIPPED);
    }

    private int getNumberOfStepsWithStatus(Status status) {
        return (int)this.getSteps().stream().filter(step -> step.getConsolidatedStatus() == status).count();
    }

    public long getTotalDuration() {
        long totalDurationNanoseconds = this.before.stream().mapToLong(beforeStep -> beforeStep.getResult().getDuration()).sum();
        totalDurationNanoseconds += this.backgroundSteps.stream().mapToLong(Step::getTotalDuration).sum();
        totalDurationNanoseconds += this.steps.stream().mapToLong(Step::getTotalDuration).sum();
        return totalDurationNanoseconds += this.after.stream().mapToLong(afterStep -> afterStep.getResult().getDuration()).sum();
    }

    public String returnTotalDurationString() {
        return RenderingUtils.convertNanosecondsToTimeString(this.getTotalDuration());
    }

    public boolean hasHooks() {
        return this.getBefore().size() > 0 || this.getAfter().size() > 0;
    }

    public boolean hasHooksWithContent() {
        return this.anyBeforeHookHasContent() || this.anyAfterHookHasContent();
    }

    public boolean hasDocStrings() {
        for (Step step : this.backgroundSteps) {
            if (step.getDocString() == null) continue;
            return true;
        }
        for (Step step : this.steps) {
            if (step.getDocString() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasStepHooks() {
        for (Step step : this.backgroundSteps) {
            if (step.getBefore().size() > 0) {
                return true;
            }
            if (step.getAfter().size() <= 0) continue;
            return true;
        }
        for (Step step : this.steps) {
            if (step.getBefore().size() > 0) {
                return true;
            }
            if (step.getAfter().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasStepHooksWithContent() {
        for (Step step : this.backgroundSteps) {
            if (!step.hasHooksWithContent()) continue;
            return true;
        }
        for (Step step : this.steps) {
            if (!step.hasHooksWithContent()) continue;
            return true;
        }
        return false;
    }

    public List<ResultMatch> getAllResultMatches() {
        ArrayList<ResultMatch> resultMatches = new ArrayList<ResultMatch>(this.getBefore());
        resultMatches.addAll(this.getBackgroundSteps());
        resultMatches.addAll(this.getSteps());
        resultMatches.addAll(this.getAfter());
        return resultMatches;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public int getFeatureIndex() {
        return this.featureIndex;
    }

    public void setFeatureIndex(int featureIndex) {
        this.featureIndex = featureIndex;
    }

    public void setFailOnPendingOrUndefined(boolean failOnPendingOrUndefined) {
        this.failOnPendingOrUndefined = failOnPendingOrUndefined;
    }

    public String getFeatureUri() {
        return this.featureUri;
    }

    public void setFeatureUri(String featureUri) {
        this.featureUri = featureUri;
    }
}

