/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.renderering;

import com.trivago.cluecumber.constants.ChartConfiguration;
import com.trivago.cluecumber.constants.PluginSettings;
import com.trivago.cluecumber.constants.Status;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.json.pojo.Tag;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.rendering.pages.charts.StackedBarChartBuilder;
import com.trivago.cluecumber.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllTagsPageCollection;
import com.trivago.cluecumber.rendering.pages.renderering.PageWithChartRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AllTagsPageRenderer
extends PageWithChartRenderer {
    private final ChartConfiguration chartConfiguration;
    private final PropertyManager propertyManager;

    @Inject
    public AllTagsPageRenderer(ChartJsonConverter chartJsonConverter, ChartConfiguration chartConfiguration, PropertyManager propertyManager) {
        super(chartJsonConverter);
        this.chartConfiguration = chartConfiguration;
        this.propertyManager = propertyManager;
    }

    public String getRenderedContent(AllTagsPageCollection allTagsPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(allTagsPageCollection);
        if (this.propertyManager.getCustomParametersDisplayMode() == PluginSettings.CustomParamDisplayMode.ALL_PAGES) {
            this.addCustomParametersToReportDetails(allTagsPageCollection, this.propertyManager.getCustomParameters());
        }
        return this.processedContent(template, allTagsPageCollection, this.propertyManager.getNavigationLinks());
    }

    private void addChartJsonToReportDetails(AllTagsPageCollection allTagsPageCollection) {
        ArrayList<Float> passed = new ArrayList<Float>();
        ArrayList<Float> failed = new ArrayList<Float>();
        ArrayList<Float> skipped = new ArrayList<Float>();
        int maximumNumberOfRuns = 0;
        for (Map.Entry<Tag, ResultCount> entry : allTagsPageCollection.getTagResultCounts().entrySet()) {
            ResultCount value = entry.getValue();
            passed.add(Float.valueOf(value.getPassed()));
            failed.add(Float.valueOf(value.getFailed()));
            skipped.add(Float.valueOf(value.getSkipped()));
            if (value.getTotal() <= maximumNumberOfRuns) continue;
            maximumNumberOfRuns = value.getTotal();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Tag tag : allTagsPageCollection.getTagResultCounts().keySet()) {
            keys.add(tag.getName());
        }
        Chart chart = new StackedBarChartBuilder(this.chartConfiguration).setLabels(keys).setxAxisLabel(allTagsPageCollection.getTotalNumberOfTags() + " Tags").setyAxisLabel("Number of Scenarios").setyAxisStepSize(maximumNumberOfRuns).addValues(passed, Status.PASSED).addValues(failed, Status.FAILED).addValues(skipped, Status.SKIPPED).build();
        allTagsPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }
}

