/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber;

import com.trivago.cluecumber.PropertyCollector;
import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.filesystem.FileIO;
import com.trivago.cluecumber.filesystem.FileSystemManager;
import com.trivago.cluecumber.json.JsonPojoConverter;
import com.trivago.cluecumber.json.pojo.Report;
import com.trivago.cluecumber.json.processors.ElementIndexPreProcessor;
import com.trivago.cluecumber.logging.CluecumberLogger;
import com.trivago.cluecumber.properties.PropertyManager;
import com.trivago.cluecumber.rendering.ReportGenerator;
import com.trivago.cluecumber.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="reporting", requiresProject=false)
public final class CluecumberReportPlugin
extends PropertyCollector {
    private final CluecumberLogger logger;
    private final PropertyManager propertyManager;
    private final FileSystemManager fileSystemManager;
    private final FileIO fileIO;
    private final JsonPojoConverter jsonPojoConverter;
    private final ElementIndexPreProcessor elementIndexPreProcessor;
    private final ReportGenerator reportGenerator;
    @Parameter(defaultValue="false", property="skip")
    private boolean skip;

    @Inject
    public CluecumberReportPlugin(CluecumberLogger logger, PropertyManager propertyManager, FileSystemManager fileSystemManager, FileIO fileIO, JsonPojoConverter jsonPojoConverter, ElementIndexPreProcessor elementIndexPreProcessor, ReportGenerator reportGenerator) {
        super(propertyManager);
        this.propertyManager = propertyManager;
        this.fileSystemManager = fileSystemManager;
        this.fileIO = fileIO;
        this.jsonPojoConverter = jsonPojoConverter;
        this.logger = logger;
        this.elementIndexPreProcessor = elementIndexPreProcessor;
        this.reportGenerator = reportGenerator;
    }

    @Override
    public void execute() throws CluecumberPluginException {
        this.logger.initialize(this.getLog(), this.logLevel);
        if (this.skip) {
            this.logger.info("Cluecumber report generation was skipped using the <skip> property.", CluecumberLogger.CluecumberLogLevel.DEFAULT);
            return;
        }
        this.logger.logInfoSeparator(CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info(String.format(" Cluecumber Report Maven Plugin, version %s", ((Object)((Object)this)).getClass().getPackage().getImplementationVersion()), CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.logInfoSeparator(CluecumberLogger.CluecumberLogLevel.DEFAULT, CluecumberLogger.CluecumberLogLevel.COMPACT);
        super.execute();
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + "/attachments");
        AllScenariosPageCollection allScenariosPageCollection = new AllScenariosPageCollection(this.propertyManager.getCustomPageTitle());
        List<Path> jsonFilePaths = this.fileSystemManager.getJsonFilePaths(this.propertyManager.getSourceJsonReportDirectory());
        for (Path jsonFilePath : jsonFilePaths) {
            String jsonString = this.fileIO.readContentFromFile(jsonFilePath.toString());
            try {
                Report[] reports = this.jsonPojoConverter.convertJsonToReportPojos(jsonString);
                allScenariosPageCollection.addReports(reports);
            }
            catch (CluecumberPluginException e) {
                this.logger.warn("Could not parse JSON in file '" + jsonFilePath.toString() + "': " + e.getMessage());
            }
        }
        this.elementIndexPreProcessor.addScenarioIndices(allScenariosPageCollection.getReports());
        this.reportGenerator.generateReport(allScenariosPageCollection);
        this.logger.info("=> Cluecumber Report: " + this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "index" + ".html", CluecumberLogger.CluecumberLogLevel.DEFAULT, CluecumberLogger.CluecumberLogLevel.COMPACT, CluecumberLogger.CluecumberLogLevel.MINIMAL);
    }
}

