/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.features;

import com.trivago.vo.DataTable;
import com.trivago.vo.SingleScenario;
import com.trivago.vo.Step;
import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;

@Singleton
public class FeatureFileContentRenderer {
    private static final String LINE_SEPARATOR = System.lineSeparator();

    private String getRenderedFeatureFileContent(List<SingleScenario> singleScenarios) {
        StringBuilder renderedContent = new StringBuilder();
        SingleScenario firstScenario = singleScenarios.get(0);
        this.addLanguage(renderedContent, firstScenario.getFeatureLanguage());
        this.addTags(renderedContent, firstScenario.getFeatureTags());
        this.addNameAndDescription(renderedContent, firstScenario.getFeatureName(), firstScenario.getFeatureDescription());
        this.addBackgroundSteps(renderedContent, firstScenario.getBackgroundSteps());
        for (SingleScenario singleScenario : singleScenarios) {
            renderedContent.append(LINE_SEPARATOR);
            List<String> scenarioTags = singleScenario.getScenarioTags();
            if (scenarioTags != null && firstScenario.getFeatureTags() != null) {
                scenarioTags.removeAll(firstScenario.getFeatureTags());
            }
            this.addTags(renderedContent, scenarioTags);
            this.addTags(renderedContent, singleScenario.getExampleTags());
            this.addNameAndDescription(renderedContent, singleScenario.getScenarioName(), singleScenario.getScenarioDescription());
            this.addSteps(renderedContent, singleScenario.getSteps());
            if (!singleScenario.isScenarioOutline()) continue;
            this.addExamplesTable(renderedContent, singleScenario.getExampleHeaders(), singleScenario.getExampleRow(), singleScenario.getExamplesKeyword());
        }
        this.addComments(renderedContent, firstScenario.getFeatureFilePath());
        return renderedContent.toString();
    }

    String getRenderedFeatureFileContent(SingleScenario singleScenario) {
        return this.getRenderedFeatureFileContent(Collections.singletonList(singleScenario));
    }

    private void addLanguage(StringBuilder stringBuilder, String featureLanguage) {
        if (featureLanguage == null || featureLanguage.isEmpty()) {
            return;
        }
        stringBuilder.append("# language: ").append(featureLanguage).append(LINE_SEPARATOR).append(LINE_SEPARATOR);
    }

    private void addComments(StringBuilder stringBuilder, String featureFilePath) {
        stringBuilder.append(LINE_SEPARATOR).append("# Source feature: ").append(featureFilePath.replace("\\", "/")).append(LINE_SEPARATOR).append("# Generated by Cucable ").append(this.getClass().getPackage().getImplementationVersion()).append(LINE_SEPARATOR);
    }

    private void addSteps(StringBuilder stringBuilder, List<Step> steps) {
        if (steps == null) {
            return;
        }
        for (Step step : steps) {
            stringBuilder.append("    ").append(step.getName()).append(LINE_SEPARATOR);
            stringBuilder.append(this.formatDocString(step.getDocString()));
            stringBuilder.append(this.formatDataTableString(step.getDataTable()));
        }
    }

    private void addBackgroundSteps(StringBuilder stringBuilder, List<Step> backgroundSteps) {
        if (backgroundSteps == null || backgroundSteps.isEmpty()) {
            return;
        }
        stringBuilder.append(LINE_SEPARATOR).append("Background:").append(LINE_SEPARATOR);
        this.addSteps(stringBuilder, backgroundSteps);
    }

    private void addNameAndDescription(StringBuilder stringBuilder, String name, String description) {
        stringBuilder.append(name);
        if (description != null && !description.isEmpty()) {
            stringBuilder.append(LINE_SEPARATOR).append(description);
        }
        stringBuilder.append(LINE_SEPARATOR);
    }

    private void addTags(StringBuilder stringBuilder, List<String> tags) {
        if (tags == null) {
            return;
        }
        for (String tag : tags) {
            stringBuilder.append(tag).append(LINE_SEPARATOR);
        }
    }

    private String formatDataTableString(DataTable dataTable) {
        if (dataTable == null) {
            return "";
        }
        char dataTableSeparator = '|';
        StringBuilder dataTableStringBuilder = new StringBuilder();
        for (List<String> rowValues : dataTable.getRows()) {
            dataTableStringBuilder.append("      ").append(dataTableSeparator);
            for (String rowValue : rowValues) {
                dataTableStringBuilder.append(" ").append(rowValue).append(" ").append(dataTableSeparator);
            }
            dataTableStringBuilder.append(LINE_SEPARATOR);
        }
        return dataTableStringBuilder.toString();
    }

    private String formatDocString(String docString) {
        if (docString == null || docString.isEmpty()) {
            return "";
        }
        return "\"\"\"" + LINE_SEPARATOR + docString + LINE_SEPARATOR + "\"\"\"" + LINE_SEPARATOR;
    }

    private void addExamplesTable(StringBuilder stringBuilder, List<String> headers, List<String> row, String examplesKeyword) {
        if (headers == null || headers.isEmpty() || row == null || row.isEmpty()) {
            return;
        }
        Object keyword = examplesKeyword;
        if (!((String)keyword).endsWith(":")) {
            keyword = (String)keyword + ":";
        }
        stringBuilder.append(LINE_SEPARATOR).append("  ").append((String)keyword).append(LINE_SEPARATOR);
        stringBuilder.append("      |");
        for (String header : headers) {
            stringBuilder.append(" ").append(header).append(" |");
        }
        stringBuilder.append(LINE_SEPARATOR);
        stringBuilder.append("      |");
        for (String value : row) {
            stringBuilder.append(" ").append(value).append(" |");
        }
        stringBuilder.append(LINE_SEPARATOR);
    }
}

