/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.features;

import com.trivago.exceptions.CucablePluginException;
import com.trivago.exceptions.filesystem.FileCreationException;
import com.trivago.exceptions.filesystem.MissingFileException;
import com.trivago.features.FeatureFileContentRenderer;
import com.trivago.files.FileSystemManager;
import com.trivago.gherkin.GherkinDocumentParser;
import com.trivago.logging.CucableLogger;
import com.trivago.logging.Language;
import com.trivago.properties.PropertyManager;
import com.trivago.runners.RunnerFileContentRenderer;
import com.trivago.vo.CucableFeature;
import com.trivago.vo.FeatureRunner;
import com.trivago.vo.SingleScenario;
import io.cucumber.gherkin.GherkinParser;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FeatureFileConverter {
    private static final String FEATURE_FILE_EXTENSION = ".feature";
    private static final String RUNNER_FILE_EXTENSION = ".java";
    private static final String INTEGRATION_TEST_POSTFIX = "_IT";
    private static final String PATH_SEPARATOR = "/";
    private static final String TEST_RUNS_COUNTER_FORMAT = "_run%03d";
    private static final String FEATURE_COUNTER_FORMAT = "_feature%03d";
    private static final String SCENARIO_COUNTER_FORMAT = "_scenario%03d";
    private final PropertyManager propertyManager;
    private final GherkinDocumentParser gherkinDocumentParser;
    private final FeatureFileContentRenderer featureFileContentRenderer;
    private final RunnerFileContentRenderer runnerFileContentRenderer;
    private final FileSystemManager fileSystemManager;
    private final CucableLogger logger;
    private final Map<String, Integer> scenarioPerFeatureCounters = new HashMap<String, Integer>();
    private int featurePostfix = 0;

    @Inject
    public FeatureFileConverter(PropertyManager propertyManager, GherkinDocumentParser gherkinDocumentParser, FeatureFileContentRenderer featureFileContentRenderer, RunnerFileContentRenderer runnerFileContentRenderer, FileSystemManager fileSystemManager, CucableLogger logger) {
        this.propertyManager = propertyManager;
        this.gherkinDocumentParser = gherkinDocumentParser;
        this.featureFileContentRenderer = featureFileContentRenderer;
        this.runnerFileContentRenderer = runnerFileContentRenderer;
        this.fileSystemManager = fileSystemManager;
        this.logger = logger;
    }

    public void generateParallelizableFeatures(List<CucableFeature> cucableFeatures) throws CucablePluginException {
        int featureFileCounter = 0;
        ArrayList<String> allGeneratedFeaturePaths = new ArrayList<String>();
        for (CucableFeature cucableFeature : cucableFeatures) {
            List<Path> paths = this.fileSystemManager.getPathsFromCucableFeature(cucableFeature);
            if (paths.isEmpty()) {
                this.logger.warn("No features and runners could be created. Please check your properties!");
            }
            for (Path path : paths) {
                List<String> generatedFeatureFilePaths = this.generateParallelizableFeatures(path, cucableFeature.getLineNumbers());
                allGeneratedFeaturePaths.addAll(generatedFeatureFilePaths);
                featureFileCounter += generatedFeatureFilePaths.size();
            }
        }
        for (Map.Entry entry : this.scenarioPerFeatureCounters.entrySet()) {
            this.logFeatureFileConversionMessage((String)entry.getKey(), (Integer)entry.getValue());
        }
        int runnerFileCounter = this.propertyManager.getDesiredNumberOfFeaturesPerRunner() > 0 ? this.generateRunnerClassesWithDesiredNumberOfFeatures(allGeneratedFeaturePaths, this.propertyManager.getDesiredNumberOfFeaturesPerRunner()) : this.generateRunnerClassesWithDesiredNumberOfRunners(allGeneratedFeaturePaths, this.propertyManager.getDesiredNumberOfRunners());
        this.logger.logInfoSeparator(CucableLogger.CucableLogLevel.DEFAULT);
        this.logger.info(String.format("Cucable created %d separate %s and %d %s.", featureFileCounter, Language.singularPlural(featureFileCounter, "feature file", "feature files"), runnerFileCounter, Language.singularPlural(runnerFileCounter, "runner", "runners")), CucableLogger.CucableLogLevel.DEFAULT, CucableLogger.CucableLogLevel.COMPACT, CucableLogger.CucableLogLevel.MINIMAL);
    }

    private List<String> generateParallelizableFeatures(Path sourceFeatureFilePath, List<Integer> lineNumbers) throws CucablePluginException {
        if (this.propertyManager.getParallelizationMode() == PropertyManager.ParallelizationMode.SCENARIOS) {
            return this.generateFeaturesWithScenariosParallelizationMode(sourceFeatureFilePath, lineNumbers);
        }
        return this.generateFeaturesWithFeaturesParallelizationMode(sourceFeatureFilePath);
    }

    private List<String> generateFeaturesWithFeaturesParallelizationMode(Path sourceFeatureFilePath) throws CucablePluginException {
        String featureFilePathString = sourceFeatureFilePath.toString();
        String featureFileContent = this.fileSystemManager.readContentFromFile(featureFilePathString);
        return this.generateFeatureFiles(sourceFeatureFilePath, featureFileContent);
    }

    private List<String> generateFeaturesWithScenariosParallelizationMode(Path sourceFeatureFilePath, List<Integer> lineNumbers) throws CucablePluginException {
        String featureFilePathString = sourceFeatureFilePath.toString();
        if (featureFilePathString.isEmpty()) {
            throw new MissingFileException(featureFilePathString);
        }
        String featureFileContent = this.fileSystemManager.readContentFromFile(featureFilePathString);
        List<SingleScenario> singleScenarios = this.gherkinDocumentParser.getSingleScenariosFromFeature(featureFileContent, featureFilePathString, lineNumbers);
        return this.generateFeatureFiles(sourceFeatureFilePath, singleScenarios);
    }

    private List<String> generateFeatureFiles(Path sourceFeatureFilePath, List<SingleScenario> singleScenarios) throws FileCreationException {
        ArrayList<String> generatedFeaturePaths = new ArrayList<String>();
        ++this.featurePostfix;
        for (SingleScenario singleScenario : singleScenarios) {
            Integer scenarioPerFeatureCounter;
            String featureFileName = this.getFeatureFileNameFromPath(sourceFeatureFilePath) + "_" + this.featurePostfix;
            Integer n = scenarioPerFeatureCounter = this.scenarioPerFeatureCounters.getOrDefault(sourceFeatureFilePath.toString(), 0);
            scenarioPerFeatureCounter = scenarioPerFeatureCounter + 1;
            String scenarioCounterFilenamePart = String.format(SCENARIO_COUNTER_FORMAT, scenarioPerFeatureCounter);
            for (int testRuns = 1; testRuns <= this.propertyManager.getNumberOfTestRuns(); ++testRuns) {
                String generatedFileName = featureFileName.concat(scenarioCounterFilenamePart);
                String testRunsCounterFilenamePart = String.format(TEST_RUNS_COUNTER_FORMAT, testRuns);
                generatedFileName = generatedFileName.concat(testRunsCounterFilenamePart).concat(INTEGRATION_TEST_POSTFIX);
                this.saveFeature(generatedFileName, this.featureFileContentRenderer.getRenderedFeatureFileContent(singleScenario));
                generatedFeaturePaths.add(generatedFileName);
                this.scenarioPerFeatureCounters.put(sourceFeatureFilePath.toString(), scenarioPerFeatureCounter);
                this.fileSystemManager.writeContentToFile(generatedFileName + "=" + singleScenario.getFeatureFilePath() + ":" + singleScenario.getEffectiveLineNumber() + "\n", this.propertyManager.getGeneratedFeatureDirectory() + "/generated-features.properties");
            }
        }
        return generatedFeaturePaths;
    }

    private List<String> generateFeatureFiles(Path sourceFeatureFilePath, String featureFileContent) throws FileCreationException {
        Integer featureCounter;
        ArrayList<String> generatedFeaturePaths = new ArrayList<String>();
        ++this.featurePostfix;
        String featureFileName = this.getFeatureFileNameFromPath(sourceFeatureFilePath) + "_" + this.featurePostfix;
        Integer n = featureCounter = this.scenarioPerFeatureCounters.getOrDefault(sourceFeatureFilePath.toString(), 0);
        featureCounter = featureCounter + 1;
        String featureCounterFilenamePart = String.format(FEATURE_COUNTER_FORMAT, featureCounter);
        for (int testRuns = 1; testRuns <= this.propertyManager.getNumberOfTestRuns(); ++testRuns) {
            String testRunsCounterFilenamePart = String.format(TEST_RUNS_COUNTER_FORMAT, testRuns);
            String generatedFileName = featureFileName.concat(featureCounterFilenamePart).concat(testRunsCounterFilenamePart).concat(INTEGRATION_TEST_POSTFIX);
            this.saveFeature(generatedFileName, featureFileContent);
            this.fileSystemManager.writeContentToFile(generatedFileName + "=" + String.valueOf(sourceFeatureFilePath) + ":1\n", this.propertyManager.getGeneratedFeatureDirectory() + "/generated-features.properties");
            generatedFeaturePaths.add(generatedFileName);
            this.scenarioPerFeatureCounters.put(sourceFeatureFilePath.toString(), featureCounter);
        }
        return generatedFeaturePaths;
    }

    private void saveFeature(String featureFileName, String renderedFeatureFileContent) throws FileCreationException {
        String generatedFeatureFilePath = this.propertyManager.getGeneratedFeatureDirectory().concat(PATH_SEPARATOR).concat(featureFileName).concat(FEATURE_FILE_EXTENSION);
        this.fileSystemManager.writeContentToFile(renderedFeatureFileContent, generatedFeatureFilePath);
    }

    private int generateRunnerClassesWithDesiredNumberOfRunners(List<String> generatedFeatureNames, int numberOfDesiredRunners) throws CucablePluginException {
        int targetRunnerNumber = numberOfDesiredRunners;
        List<String> scenarioNames = this.propertyManager.getScenarioNames();
        if (targetRunnerNumber == -1) {
            targetRunnerNumber = generatedFeatureNames.size();
        } else if (targetRunnerNumber == 0) {
            return 0;
        }
        ArrayList generatedFeatureNamesPerRunner = new ArrayList(targetRunnerNumber);
        for (int i = 0; i < targetRunnerNumber; ++i) {
            generatedFeatureNamesPerRunner.add(new ArrayList());
        }
        int currentRunnerIndex = 0;
        int matchCount = 0;
        for (String generatedFeatureName : generatedFeatureNames) {
            int listIndex;
            if (scenarioNames.isEmpty()) {
                ((List)generatedFeatureNamesPerRunner.get(currentRunnerIndex)).add(generatedFeatureName);
                if (++currentRunnerIndex < targetRunnerNumber) continue;
                currentRunnerIndex = 0;
                continue;
            }
            String string = this.fileSystemManager.readContentFromFile(this.propertyManager.getGeneratedFeatureDirectory() + PATH_SEPARATOR + generatedFeatureName + FEATURE_FILE_EXTENSION);
            if (string == null) continue;
            GherkinParser parser = GherkinParser.builder().build();
            String language = "en";
            try {
                language = parser.parse("scenario.feature", (InputStream)new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8))).filter(envelope -> envelope.getGherkinDocument().isPresent()).map(envelope -> ((GherkinDocument)envelope.getGherkinDocument().get()).getFeature()).filter(feature -> feature.isPresent()).map(feature -> ((Feature)feature.get()).getLanguage()).findFirst().orElse("en");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if ((listIndex = this.gherkinDocumentParser.matchScenarioWithScenarioNames(string)) < 0) continue;
            ((List)generatedFeatureNamesPerRunner.get(listIndex)).add(generatedFeatureName);
            ++matchCount;
        }
        if (!scenarioNames.isEmpty() && matchCount == 0) {
            throw new CucablePluginException("No matching scenarios found for specified scenario names - " + Arrays.toString(scenarioNames.toArray()) + "!");
        }
        int runnerFileCounter = 0;
        for (List list : generatedFeatureNamesPerRunner) {
            if (list.isEmpty()) continue;
            this.generateRunnerClass(list);
            ++runnerFileCounter;
        }
        return runnerFileCounter;
    }

    private int generateRunnerClassesWithDesiredNumberOfFeatures(List<String> generatedFeatureNames, int numberOfDesiredFeaturesPerRunner) throws CucablePluginException {
        int currentRunnerFeatureCount = 0;
        int totalFeatureCount = 0;
        ArrayList<String> generatedFeatureNamesForSingleRunner = new ArrayList<String>();
        int runnerFileCounter = 0;
        for (String generatedFeatureName : generatedFeatureNames) {
            generatedFeatureNamesForSingleRunner.add(generatedFeatureName);
            if (++totalFeatureCount != generatedFeatureNames.size() && ++currentRunnerFeatureCount < numberOfDesiredFeaturesPerRunner) continue;
            ++runnerFileCounter;
            this.generateRunnerClass(generatedFeatureNamesForSingleRunner);
            currentRunnerFeatureCount = 0;
            generatedFeatureNamesForSingleRunner = new ArrayList();
        }
        return runnerFileCounter;
    }

    private void generateRunnerClass(List<String> generatedFeatureFileNames) throws CucablePluginException {
        Object runnerClassName = generatedFeatureFileNames.size() == 1 ? "Runner_" + generatedFeatureFileNames.get(0) : "CucableMultiRunner_".concat(UUID.randomUUID().toString().replace("-", "_")).concat(INTEGRATION_TEST_POSTFIX);
        FeatureRunner featureRunner = new FeatureRunner(this.propertyManager.getSourceRunnerTemplateFile(), (String)runnerClassName, generatedFeatureFileNames);
        String renderedRunnerClassContent = this.runnerFileContentRenderer.getRenderedRunnerFileContent(featureRunner);
        String generatedRunnerClassFilePath = this.propertyManager.getGeneratedRunnerDirectory().concat(PATH_SEPARATOR).concat((String)runnerClassName).concat(RUNNER_FILE_EXTENSION);
        this.fileSystemManager.writeContentToFile(renderedRunnerClassContent, generatedRunnerClassFilePath);
    }

    private void logFeatureFileConversionMessage(String featureFileName, int createdScenarios) {
        this.logger.info(String.format("- generated %3d %s %s", createdScenarios, Language.singularPlural(createdScenarios, "feature file  from", "feature files from"), featureFileName), CucableLogger.CucableLogLevel.DEFAULT);
    }

    private String getFeatureFileNameFromPath(Path featureFilePath) {
        String fullFeatureFileName = featureFilePath.getFileName().toString();
        String featureFileName = fullFeatureFileName.substring(0, fullFeatureFileName.lastIndexOf("."));
        return featureFileName.replaceAll("\\W", "_");
    }
}

