/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.files;

import com.trivago.exceptions.CucablePluginException;
import com.trivago.exceptions.filesystem.FileCreationException;
import com.trivago.exceptions.filesystem.FileDeletionException;
import com.trivago.exceptions.filesystem.MissingFileException;
import com.trivago.exceptions.filesystem.PathCreationException;
import com.trivago.vo.CucableFeature;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.codehaus.plexus.util.FileUtils;

@Singleton
public class FileSystemManager {
    public static final String FEATURE_FILE_EXTENSION = "feature";
    public static final String TEXT_FILE_EXTENSION = "txt";

    @Inject
    public FileSystemManager() {
    }

    public List<Path> getPathsFromCucableFeature(CucableFeature cucableFeature) throws CucablePluginException {
        if (cucableFeature == null) {
            return Collections.emptyList();
        }
        String sourceFeatures = cucableFeature.getName().replace("file://", "");
        File sourceFeaturesFile = new File(sourceFeatures);
        if (sourceFeatures.trim().isEmpty()) {
            return Collections.emptyList();
        }
        if (sourceFeaturesFile.isFile() && sourceFeatures.endsWith(FEATURE_FILE_EXTENSION)) {
            return Collections.singletonList(Paths.get(sourceFeatures, new String[0]));
        }
        if (sourceFeaturesFile.isDirectory()) {
            return this.getFilesWithExtension(sourceFeatures, FEATURE_FILE_EXTENSION);
        }
        throw new CucablePluginException(sourceFeatures + " is not a feature file or a directory.");
    }

    public List<Path> getFilesWithExtension(String sourceFeatureDirectory, String extension) throws CucablePluginException {
        List<Path> list;
        block8: {
            Stream<Path> paths = Files.walk(Paths.get(sourceFeatureDirectory, new String[0]), new FileVisitOption[0]);
            try {
                list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith("." + extension)).sorted().collect(Collectors.toList());
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CucablePluginException("Unable to traverse " + extension + " files in " + sourceFeatureDirectory + ": " + e.getMessage());
                }
            }
            paths.close();
        }
        return list;
    }

    public void prepareGeneratedFeatureAndRunnerDirectories(String runnerDir, String featureDir) throws CucablePluginException {
        this.createDirIfNotExists(featureDir);
        this.removeFilesFromPath(featureDir, FEATURE_FILE_EXTENSION);
        if (runnerDir != null && !runnerDir.isEmpty()) {
            this.createDirIfNotExists(runnerDir);
            this.removeFilesFromPath(runnerDir, "java");
        }
    }

    private void createDirIfNotExists(String dirName) throws PathCreationException {
        File directory = new File(dirName);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new PathCreationException(dirName);
        }
    }

    private void removeFilesFromPath(String path, String fileExtension) throws FileDeletionException {
        File basePath = new File(path);
        File[] files = basePath.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith("." + fileExtension) || file.delete()) continue;
                throw new FileDeletionException(file.getName());
            }
        }
    }

    public void writeContentToFile(String content, String filePath) throws FileCreationException {
        try {
            Path path = Paths.get(filePath, new String[0]);
            Files.write(path, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (Exception e) {
            throw new FileCreationException(filePath);
        }
    }

    public String readContentFromFile(String filePath) throws MissingFileException {
        try {
            return FileUtils.fileRead((String)filePath, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new MissingFileException(filePath);
        }
    }
}

