/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.gherkin;

import com.trivago.exceptions.CucablePluginException;
import com.trivago.exceptions.filesystem.FeatureFileParseException;
import com.trivago.gherkin.GherkinToCucableConverter;
import com.trivago.logging.CucableLogger;
import com.trivago.properties.PropertyManager;
import com.trivago.vo.DataTable;
import com.trivago.vo.SingleScenario;
import com.trivago.vo.Step;
import io.cucumber.gherkin.GherkinParser;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleDocString;
import io.cucumber.messages.types.PickleStepArgument;
import io.cucumber.messages.types.PickleTable;
import io.cucumber.messages.types.PickleTag;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionException;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GherkinDocumentParser {
    private final GherkinToCucableConverter gherkinToCucableConverter;
    private final PropertyManager propertyManager;
    private final CucableLogger cucableLogger;

    @Inject
    GherkinDocumentParser(GherkinToCucableConverter gherkinToCucableConverter, PropertyManager propertyManager, CucableLogger logger) {
        this.gherkinToCucableConverter = gherkinToCucableConverter;
        this.propertyManager = propertyManager;
        this.cucableLogger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SingleScenario> getSingleScenariosFromFeature(String featureContent, String featureFilePath, List<Integer> scenarioLineNumbers) throws CucablePluginException {
        String escapedFeatureContent = featureContent.replace("\\n", "\\\\n");
        ArrayList<SingleScenario> singleScenarioFeatures = new ArrayList<SingleScenario>();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(escapedFeatureContent.getBytes(StandardCharsets.UTF_8));){
            GherkinParser gherkinParser = GherkinParser.builder().build();
            ArrayList<Pickle> pickles = new ArrayList<Pickle>();
            Feature feature = null;
            List envelopes = gherkinParser.parse(featureFilePath, (InputStream)inputStream).collect(Collectors.toList());
            boolean hasParseErrors = envelopes.stream().anyMatch(envelope -> envelope.getParseError().isPresent());
            if (hasParseErrors) {
                throw new CucablePluginException("Failed to parse Gherkin feature file: " + featureFilePath);
            }
            for (Envelope envelope2 : envelopes) {
                if (envelope2.getGherkinDocument().isPresent() && ((GherkinDocument)envelope2.getGherkinDocument().get()).getFeature().isPresent()) {
                    feature = (Feature)((GherkinDocument)envelope2.getGherkinDocument().get()).getFeature().get();
                }
                if (!envelope2.getPickle().isPresent()) continue;
                pickles.add((Pickle)envelope2.getPickle().get());
            }
            if (feature == null) {
                this.cucableLogger.warn("No parsable gherkin in feature file: " + this.getFeatureFileNameFromPath(featureFilePath));
                List list = Collections.emptyList();
                return list;
            }
            String featureName = feature.getKeyword() + ": " + feature.getName();
            String featureLanguage = feature.getLanguage();
            String featureDescription = feature.getDescription();
            List<String> featureTags = this.gherkinToCucableConverter.convertGherkinTagsToCucableTags(feature.getTags());
            List<Step> backgroundSteps = this.getBackgroundSteps(feature);
            HashMap<String, io.cucumber.messages.types.Step> stepIdMap = new HashMap<String, io.cucumber.messages.types.Step>();
            HashMap<String, String> scenarioKeywordMap = new HashMap<String, String>();
            HashMap<String, Scenario> scenarioMap = new HashMap<String, Scenario>();
            for (FeatureChild child : feature.getChildren()) {
                if (child.getBackground().isPresent()) {
                    for (io.cucumber.messages.types.Step step : ((Background)child.getBackground().get()).getSteps()) {
                        stepIdMap.put(step.getId(), step);
                    }
                }
                if (!child.getScenario().isPresent()) continue;
                Scenario scenario = (Scenario)child.getScenario().get();
                scenarioKeywordMap.put(scenario.getId(), scenario.getKeyword());
                scenarioMap.put(scenario.getId(), scenario);
                for (io.cucumber.messages.types.Step step : scenario.getSteps()) {
                    stepIdMap.put(step.getId(), step);
                }
            }
            boolean hasLineNumberFilter = scenarioLineNumbers != null && !scenarioLineNumbers.isEmpty();
            ArrayList<Integer> requestedLineNumbers = hasLineNumberFilter ? new ArrayList<Integer>(scenarioLineNumbers) : new ArrayList();
            HashSet<Integer> matchedLineNumbers = new HashSet<Integer>();
            for (Pickle pickle : pickles) {
                int parentScenarioLineNumber = 0;
                String scenarioKeyword = "Scenario";
                Scenario originalScenario = null;
                if (!pickle.getAstNodeIds().isEmpty()) {
                    String scenarioId = (String)pickle.getAstNodeIds().get(0);
                    scenarioKeyword = scenarioKeywordMap.getOrDefault(scenarioId, "Scenario");
                    originalScenario = (Scenario)scenarioMap.get(scenarioId);
                    if (originalScenario != null && originalScenario.getLocation() != null) {
                        parentScenarioLineNumber = originalScenario.getLocation().getLine().intValue();
                    }
                }
                boolean isScenarioOutline = originalScenario != null && originalScenario.getExamples() != null && !originalScenario.getExamples().isEmpty();
                boolean includeThisPickle = true;
                if (hasLineNumberFilter) {
                    if (requestedLineNumbers.contains(parentScenarioLineNumber)) {
                        includeThisPickle = true;
                        matchedLineNumbers.add(parentScenarioLineNumber);
                    } else if (isScenarioOutline) {
                        Integer currentPickleRowLine = GherkinDocumentParser.getInteger(pickle, originalScenario);
                        boolean bl = includeThisPickle = currentPickleRowLine != null && requestedLineNumbers.contains(currentPickleRowLine);
                        if (includeThisPickle && currentPickleRowLine != null) {
                            matchedLineNumbers.add(currentPickleRowLine);
                        }
                    } else {
                        includeThisPickle = false;
                    }
                }
                if (!includeThisPickle) continue;
                String scenarioName = isScenarioOutline ? scenarioKeyword + ": " + originalScenario.getName() : scenarioKeyword + ": " + pickle.getName();
                SingleScenario singleScenario = new SingleScenario(featureName, featureFilePath, featureLanguage, featureDescription, scenarioName, parentScenarioLineNumber, "", featureTags, backgroundSteps);
                if (isScenarioOutline) {
                    singleScenario.setScenarioOutline(true);
                    List<String> headers = new ArrayList<String>();
                    List<String> rowValues = new ArrayList<String>();
                    Object examplesKeyword = "Examples:";
                    Integer currentExampleRowLineNumber = null;
                    if (originalScenario.getExamples() != null) {
                        for (Examples examples : originalScenario.getExamples()) {
                            if (examples.getKeyword() != null && !examples.getKeyword().isEmpty()) {
                                examplesKeyword = examples.getKeyword();
                            }
                            if (examples.getTableHeader().isPresent()) {
                                headers = ((TableRow)examples.getTableHeader().get()).getCells().stream().map(TableCell::getValue).collect(Collectors.toList());
                            }
                            for (TableRow tableRow : examples.getTableBody()) {
                                if (!pickle.getAstNodeIds().contains(tableRow.getId())) continue;
                                rowValues = tableRow.getCells().stream().map(TableCell::getValue).collect(Collectors.toList());
                                if (tableRow.getLocation() == null) break;
                                currentExampleRowLineNumber = tableRow.getLocation().getLine().intValue();
                                break;
                            }
                            if (rowValues.isEmpty()) continue;
                        }
                    }
                    if (currentExampleRowLineNumber != null) {
                        singleScenario.setExampleLineNumber(currentExampleRowLineNumber);
                    }
                    singleScenario.setExampleHeaders(headers);
                    singleScenario.setExampleRow(rowValues);
                    singleScenario.setExamplesKeyword((String)examplesKeyword);
                }
                List<String> tags = pickle.getTags().stream().map(PickleTag::getName).collect(Collectors.toList());
                singleScenario.setScenarioTags(tags);
                ArrayList<String> backgroundStepIds = new ArrayList<String>();
                for (FeatureChild child : feature.getChildren()) {
                    if (!child.getBackground().isPresent()) continue;
                    for (io.cucumber.messages.types.Step step : ((Background)child.getBackground().get()).getSteps()) {
                        backgroundStepIds.add(step.getId());
                    }
                }
                Scenario finalOriginalScenario = originalScenario;
                List<Step> steps = pickle.getSteps().stream().filter(pickleStep -> pickleStep.getAstNodeIds().stream().noneMatch(backgroundStepIds::contains)).map(pickleStep -> {
                    String stepText = pickleStep.getText();
                    String keyword = "";
                    for (String astId : pickleStep.getAstNodeIds()) {
                        io.cucumber.messages.types.Step gherkinStep = (io.cucumber.messages.types.Step)stepIdMap.get(astId);
                        if (gherkinStep == null) continue;
                        keyword = gherkinStep.getKeyword();
                        break;
                    }
                    if (isScenarioOutline && finalOriginalScenario != null) {
                        for (io.cucumber.messages.types.Step gherkinStep : finalOriginalScenario.getSteps()) {
                            if (!pickleStep.getAstNodeIds().contains(gherkinStep.getId())) continue;
                            stepText = gherkinStep.getText();
                            break;
                        }
                    }
                    DataTable dataTable = null;
                    String docString = null;
                    if (pickleStep.getArgument().isPresent()) {
                        PickleStepArgument argument = (PickleStepArgument)pickleStep.getArgument().get();
                        if (argument.getDataTable().isPresent()) {
                            dataTable = this.gherkinToCucableConverter.convertPickleTableToCucableDataTable((PickleTable)argument.getDataTable().get());
                        }
                        if (argument.getDocString().isPresent()) {
                            docString = ((PickleDocString)argument.getDocString().get()).getContent();
                        }
                    }
                    return new Step((keyword + stepText).trim(), dataTable, docString);
                }).collect(Collectors.toList());
                singleScenario.setSteps(steps);
                if (!this.scenarioShouldBeIncluded(singleScenario)) continue;
                singleScenarioFeatures.add(singleScenario);
            }
            if (!hasLineNumberFilter) return singleScenarioFeatures;
            this.logSkippedLineNumberWarnings(requestedLineNumbers, matchedLineNumbers, featureFilePath);
            return singleScenarioFeatures;
        }
        catch (CucablePluginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FeatureFileParseException(featureFilePath, e.getMessage());
        }
    }

    private static Integer getInteger(Pickle pickle, Scenario originalScenario) {
        Integer currentPickleRowLine = null;
        block0: for (Examples examples : originalScenario.getExamples()) {
            for (TableRow tableRow : examples.getTableBody()) {
                if (!pickle.getAstNodeIds().contains(tableRow.getId())) continue;
                if (tableRow.getLocation() == null) break block0;
                currentPickleRowLine = tableRow.getLocation().getLine().intValue();
                break block0;
            }
        }
        return currentPickleRowLine;
    }

    private void logSkippedLineNumberWarnings(List<Integer> requestedLineNumbers, Set<Integer> matchedLineNumbers, String featureFilePath) {
        String featureFileName = this.getFeatureFileNameFromPath(featureFilePath);
        for (Integer requestedLineNumber : requestedLineNumbers) {
            if (matchedLineNumbers.contains(requestedLineNumber)) continue;
            this.cucableLogger.warn("Skipping line " + requestedLineNumber + " in feature " + featureFileName + ": no scenario or example row found.");
        }
    }

    private String getFeatureFileNameFromPath(String featureFilePath) {
        if (featureFilePath == null || featureFilePath.isEmpty()) {
            return "unknown";
        }
        String[] pathParts = featureFilePath.split("[/\\\\]");
        if (pathParts.length > 0) {
            return pathParts[pathParts.length - 1];
        }
        return featureFilePath;
    }

    private List<Step> getBackgroundSteps(Feature feature) {
        for (FeatureChild child : feature.getChildren()) {
            if (!child.getBackground().isPresent()) continue;
            Background background = (Background)child.getBackground().get();
            return this.gherkinToCucableConverter.convertGherkinStepsToCucableSteps(background.getSteps());
        }
        return new ArrayList<Step>();
    }

    private boolean scenarioShouldBeIncluded(SingleScenario singleScenario) throws CucablePluginException {
        String includeScenarioTags = this.propertyManager.getIncludeScenarioTags();
        String scenarioName = singleScenario.getScenarioName();
        boolean scenarioNameMatchExists = this.matchScenarioWithScenarioNames(scenarioName) >= 0;
        List<String> combinedScenarioTags = new ArrayList<String>(singleScenario.getScenarioTags());
        combinedScenarioTags.addAll(singleScenario.getFeatureTags());
        combinedScenarioTags.addAll(singleScenario.getExampleTags());
        combinedScenarioTags = combinedScenarioTags.stream().distinct().collect(Collectors.toList());
        if (includeScenarioTags == null || includeScenarioTags.isEmpty()) {
            return scenarioNameMatchExists;
        }
        try {
            Expression tagExpression = TagExpressionParser.parse((String)includeScenarioTags);
            return tagExpression.evaluate(combinedScenarioTags) && scenarioNameMatchExists;
        }
        catch (TagExpressionException e) {
            throw new CucablePluginException("The tag expression '" + includeScenarioTags + "' is invalid: " + e.getMessage());
        }
    }

    public int matchScenarioWithScenarioNames(String stringToMatch) {
        List<String> scenarioNames = this.propertyManager.getScenarioNames();
        int matchIndex = -1;
        if (scenarioNames == null || scenarioNames.isEmpty()) {
            return 0;
        }
        for (String scenarioName : scenarioNames) {
            String regex = ".*:.+" + Pattern.quote(scenarioName);
            Pattern pattern = Pattern.compile(regex, 10);
            Matcher matcher = pattern.matcher(stringToMatch);
            if (!matcher.find()) continue;
            matchIndex = scenarioNames.indexOf(scenarioName);
            break;
        }
        return matchIndex;
    }
}

